/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.cache;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.NoSuchConstructorModuleException;
import org.mule.extensions.java.api.exception.NoSuchMethodModuleException;
import org.mule.extensions.java.internal.parameters.ConstructorIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifierFactory;
import org.mule.extensions.java.internal.util.JavaModuleUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaModuleLoadingCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaModuleLoadingCache.class);
    private final String METHOD_IDENTIFIER = "%s#%s";
    private final Map<String, Class<?>> typesCache = new ConcurrentHashMap();
    private final Map<String, List<Constructor>> constructorsCache = new ConcurrentHashMap<String, List<Constructor>>();
    private final Map<String, List<Method>> classMethodsCache = new ConcurrentHashMap<String, List<Method>>();
    private final Map<String, List<Method>> instanceMethodsCache = new ConcurrentHashMap<String, List<Method>>();
    private final Map<String, String> ambiguousExecutableWarningMessages = new ConcurrentHashMap<String, String>();

    public Class<?> loadClass(String className) {
        return this.typesCache.computeIfAbsent(className, key -> {
            try {
                return ClassUtils.loadClass((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundModuleException(e.getMessage(), e);
            }
        });
    }

    public Constructor getConstructor(ConstructorIdentifier id, Class<?> declaringClass, Map<String, TypedValue<Object>> args) {
        List constructors = this.constructorsCache.computeIfAbsent("%s#%s".formatted(declaringClass.getName(), id.getElementId()), key -> Arrays.stream(declaringClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).filter(id::matches).collect(Collectors.toList()));
        this.verifyExecutables(id, declaringClass, args, constructors);
        return (Constructor)constructors.get(0);
    }

    public Method getMethod(ExecutableIdentifier id, Class<?> clazz, Map<String, TypedValue<Object>> args, boolean expectStatic) {
        Map<String, List<Method>> methodsCache = expectStatic ? this.classMethodsCache : this.instanceMethodsCache;
        List methods = methodsCache.computeIfAbsent("%s#%s".formatted(clazz.getName(), id.getElementId()), key -> JavaModuleUtils.getPublicMethods(clazz, expectStatic).stream().filter(id::matches).collect(Collectors.toList()));
        this.verifyExecutables(id, clazz, args, methods);
        return (Method)methods.get(0);
    }

    public void verifyExecutables(ExecutableIdentifier id, Class<?> declaringClass, Map<String, TypedValue<Object>> args, List<? extends Executable> executables) {
        if (executables.size() == 0) {
            if (id instanceof ConstructorIdentifier) {
                throw new NoSuchConstructorModuleException(id, declaringClass, args);
            }
            throw new NoSuchMethodModuleException(id, declaringClass, args);
        }
        if (executables.size() > 1 && LOGGER.isWarnEnabled()) {
            LOGGER.warn(this.ambiguousExecutableWarningMessages.computeIfAbsent("%s#%s".formatted(declaringClass.getName(), id.getElementId()), key -> this.constructWarningMessage(executables, id.getExecutableTypeName(), (String)key)));
        }
    }

    private String constructWarningMessage(List<? extends Executable> executables, String category, String executableId) {
        String possibleExecutables = String.join((CharSequence)", ", executables.stream().map(ExecutableIdentifierFactory::create).map(ExecutableIdentifier::getElementId).collect(Collectors.toList()));
        StringBuilder sb = new StringBuilder();
        sb.append("There where multiple %ss found with the id \"%s\"".formatted(category, executableId));
        sb.append("The %s %s will be executed.\n".formatted(category, executables.get(0)));
        sb.append("The Possible %ss that share the same ID are [ %s ].\n".formatted(category, possibleExecutables));
        sb.append("To use a specific one, use the fully-qualified name for the argument types.");
        return sb.toString();
    }
}

