/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.loanbroker.esn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.example.loanbroker.AbstractLoanBrokerApp;
import org.mule.example.loanbroker.LocaleMessage;
import org.mule.example.loanbroker.messages.LoanQuote;
import org.mule.util.DateUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public class LoanBrokerApp
extends AbstractLoanBrokerApp {
    public static final String[][] CLI_OPTIONS = new String[][]{{"config", "true", "Configuration File(s)"}, {"main", "true", "LoanBrokerApp Class"}, {"req", "true", "Number of loan requests to use"}, {"sync", "true", "Whether to run in synchronous mode or not"}};
    private static boolean synchronous = false;

    public LoanBrokerApp() throws Exception {
    }

    public LoanBrokerApp(String config) throws Exception {
        super(config);
    }

    public static void main(String[] args) throws Exception {
        LoanBrokerApp loanBrokerApp = null;
        Map options = SystemUtils.getCommandLineOptions((String[])args, (String[][])CLI_OPTIONS);
        String config = (String)options.get("config");
        if (StringUtils.isNotBlank((String)config)) {
            String sync;
            loanBrokerApp = new LoanBrokerApp(config);
            int i = 100;
            String requests = (String)options.get("req");
            if (requests != null) {
                i = Integer.parseInt(requests);
            }
            if ((sync = (String)options.get("sync")) != null) {
                synchronous = Boolean.valueOf(sync);
            }
            if (synchronous) {
                long start = System.currentTimeMillis();
                List results = loanBrokerApp.requestSend(i, "CustomerRequests");
                System.out.println(LocaleMessage.responseNumQuotes((int)results.size()));
                ArrayList<String> output = new ArrayList<String>(results.size());
                int x = 1;
                for (LoanQuote quote : results) {
                    output.add(x + ". " + quote.toString());
                    ++x;
                }
                System.out.println(StringMessageUtils.getBoilerPlate(output, (char)'*', (int)80));
                long cur = System.currentTimeMillis();
                System.out.println(DateUtils.getFormattedDuration((long)(cur - start)));
                System.out.println(LocaleMessage.responseAvgRequest((long)((cur - start) / (long)x)));
            } else {
                loanBrokerApp.requestDispatch(i, "CustomerRequests");
            }
        } else {
            loanBrokerApp = new LoanBrokerApp(LoanBrokerApp.getInteractiveConfig());
            loanBrokerApp.run(synchronous);
        }
    }

    protected static String getInteractiveConfig() throws IOException {
        System.out.println(StringMessageUtils.getBoilerPlate((String)LocaleMessage.welcome()));
        int response = 0;
        String provider = "axis";
        while (response != 97 && response != 99) {
            System.out.println("\n" + LocaleMessage.menuOptionSoap());
            response = LoanBrokerApp.readCharacter();
            switch (response) {
                case 97: {
                    provider = "axis";
                    break;
                }
                case 99: {
                    provider = "cxf";
                }
            }
        }
        response = 0;
        while (response != 97 && response != 115) {
            System.out.println("\n" + LocaleMessage.menuOptionMode());
            response = LoanBrokerApp.readCharacter();
            switch (response) {
                case 97: {
                    System.out.println(LocaleMessage.loadingAsync());
                    synchronous = false;
                    break;
                }
                case 115: {
                    System.out.println(LocaleMessage.loadingSync());
                    synchronous = true;
                }
            }
        }
        String config = "loan-broker-" + (synchronous ? "sync" : "async") + "-config.xml";
        config = config + ",loan-broker-" + provider + "-endpoints-config.xml";
        return config;
    }
}

