/*
 * Decompiled with CFR 0.152.
 */
package org.mule.samples.loanbroker.esb.routers;

import java.util.Iterator;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.ResponseCorrelationAggregator;
import org.mule.samples.loanbroker.esb.message.LoanQuote;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.transformer.TransformerException;

public class BankQuotesResponseAggregator
extends ResponseCorrelationAggregator {
    protected UMOMessage aggregateEvents(EventGroup events) throws RoutingException {
        try {
            LoanQuote lowestQuote = null;
            LoanQuote quote = null;
            UMOEvent event = null;
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                event = (UMOEvent)iterator.next();
                quote = (LoanQuote)event.getTransformedMessage();
                this.logger.info((Object)("Processing quote: " + quote));
                if (lowestQuote == null) {
                    lowestQuote = quote;
                    continue;
                }
                if (!(quote.getInterestRate() < lowestQuote.getInterestRate())) continue;
                lowestQuote = quote;
            }
            this.logger.info((Object)("Lowest quote is: " + lowestQuote));
            return new MuleMessage(lowestQuote, (UMOMessageAdapter)event.getMessage());
        }
        catch (TransformerException e) {
            throw new RoutingException(Message.createStaticMessage((String)"Failed to get lowest quote"), (UMOMessage)new MuleMessage((Object)events), null, (Throwable)e);
        }
    }
}

