/*
 * Decompiled with CFR 0.152.
 */
package org.mule.samples.loanbroker.esb.transformers;

import org.mule.samples.loanbroker.esb.message.Customer;
import org.mule.samples.loanbroker.esb.message.CustomerQuoteRequest;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class RestRequestToCustomerRequest
extends AbstractEventAwareTransformer {
    private static final long serialVersionUID = -5017931788994993161L;

    public RestRequestToCustomerRequest() {
        this.setReturnClass(CustomerQuoteRequest.class);
    }

    public Object transform(Object src, String encoding, UMOEventContext context) throws TransformerException {
        int duration;
        double amount;
        int ssn;
        String name;
        try {
            name = this.getParam(context, "customerName");
            ssn = Integer.parseInt(this.getParam(context, "ssn"));
            amount = Double.parseDouble(this.getParam(context, "loanAmount"));
            duration = Integer.parseInt(this.getParam(context, "loanDuration"));
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
        Customer c = new Customer(name, ssn);
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, amount, duration);
        return request;
    }

    protected String getParam(UMOEventContext context, String name) throws NullPointerException {
        String value = context.getMessage().getStringProperty(name, null);
        if (value == null) {
            throw new NullPointerException("Parameter '" + name + "' must be set on the request");
        }
        return value;
    }
}

