/*
 * Decompiled with CFR 0.152.
 */
package org.mule.samples.loanbroker.esb;

import java.io.IOException;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.impl.BrokerContainerImpl;
import org.mule.MuleManager;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.extras.client.MuleClient;
import org.mule.samples.loanbroker.esb.message.Customer;
import org.mule.samples.loanbroker.esb.message.CustomerQuoteRequest;
import org.mule.umo.UMOMessage;

public class Main {
    private MuleClient client = null;
    private BrokerContainer msgBroker = new BrokerContainerImpl("ActiveMQ");

    public Main(String config) throws Exception {
        this.msgBroker.addConnector("tcp://localhost:61616");
        this.msgBroker.start();
        MuleXmlConfigurationBuilder builder = new MuleXmlConfigurationBuilder();
        builder.configure(config, null);
        this.client = new MuleClient();
    }

    public void close() throws Exception {
        MuleManager.getInstance().dispose();
        if (this.msgBroker != null) {
            this.msgBroker.stop();
        }
    }

    private static double getRandomAmount() {
        return Math.round(Math.random() * 18000.0);
    }

    private static int getRandomDuration() {
        return new Double(Math.random() * 60.0).intValue();
    }

    public UMOMessage request(CustomerQuoteRequest request) throws Exception {
        return this.client.send("vm://loan.broker.requests", (Object)request, null);
    }

    public static void main(String[] args) {
        Main loanConsumer = null;
        int response = 0;
        try {
            System.out.println("******************\nWelcome to the Mule Loan Broker ESB example. This example demonstrates using JMS, Web Services,\n Http/Rest and EJBs using an ESB architecture.\nFor more information see http://mule.mulesource.org/LoanBroker.\n\nThe example demonstrates integrating EJB applications in 2 ways -\n  1. Calling out to a remote EJB using a Mule Endpoint.\n  2. Managing an EJB as a Mule component.\n\nBoth have the same behavior but the second method allows a remote EJB to be used as if it were\n a local Mule component, thereby enabling tighter integration.\n\nPlease select [1], [2] or [q]uit\n******************");
            response = Main.getSelection();
            if (response == 49) {
                System.out.println("Loading 'Ejb via an Endpoint' version");
                loanConsumer = new Main("loan-broker-esb-mule-config.xml");
            } else if (response == 113) {
                System.out.println("Bye");
                System.exit(0);
            } else {
                System.out.println("Loading 'Managed Ejb Component' version");
                loanConsumer = new Main("loan-broker-esb-mule-config-with-ejb-container.xml");
            }
            while (response != 113) {
                System.out.println("\n[1] make a loan request");
                System.out.println("[q] quit");
                System.out.println("\nPlease make your selection: ");
                response = Main.getSelection();
                if (response == 49) {
                    CustomerQuoteRequest request = Main.getRequestFromUser();
                    UMOMessage result = loanConsumer.request(request);
                    if (result == null) {
                        System.out.println("A result was not received, an error must have occurred. Check the logs.");
                        continue;
                    }
                    System.out.println("Loan Consumer received a Quote: " + result.getPayload());
                    continue;
                }
                if (response == 113) {
                    System.out.println("Exiting now");
                    loanConsumer.close();
                    System.exit(0);
                    continue;
                }
                System.out.println("That response is not recognised, try again:");
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static int getSelection() throws IOException {
        byte[] buf = new byte[16];
        System.in.read(buf);
        return buf[0];
    }

    private static CustomerQuoteRequest getRequestFromUser() throws IOException {
        byte[] buf = new byte[128];
        System.out.println("Enter your name:");
        System.in.read(buf);
        String name = new String(buf).trim();
        System.out.println("Enter loan Amount:");
        buf = new byte[16];
        System.in.read(buf);
        String amount = new String(buf).trim();
        System.out.println("Enter loan Duration in months:");
        buf = new byte[16];
        System.in.read(buf);
        String duration = new String(buf).trim();
        int d = 0;
        try {
            d = Integer.parseInt(duration);
        }
        catch (NumberFormatException e) {
            System.out.println("Failed to parse duration: " + duration + ". Using random default");
            d = Main.getRandomDuration();
        }
        double a = 0.0;
        try {
            a = Double.valueOf(amount);
        }
        catch (NumberFormatException e) {
            System.out.println("Failed to parse amount: " + amount + ". Using random default");
            a = Main.getRandomAmount();
        }
        Customer c = new Customer(name, Main.getRandomSsn());
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, a, d);
        return request;
    }

    private static int getRandomSsn() {
        return new Double(Math.random() * 6000.0).intValue();
    }
}

