/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.loanbroker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.example.loanbroker.LocaleMessage;
import org.mule.example.loanbroker.messages.Customer;
import org.mule.example.loanbroker.messages.CustomerQuoteRequest;
import org.mule.module.client.MuleClient;
import org.mule.module.client.RemoteDispatcher;

public abstract class AbstractLoanBrokerApp {
    private List<Customer> customers = new ArrayList<Customer>();
    private RemoteDispatcher remoteClient = null;
    private String config;

    public AbstractLoanBrokerApp() throws Exception {
        this.config = null;
        this.init();
    }

    public AbstractLoanBrokerApp(String config) throws Exception {
        this.config = config;
        this.init();
    }

    protected void init() throws Exception {
        MuleClient muleClient = new MuleClient(true);
        this.remoteClient = muleClient.getRemoteDispatcher("tcp://localhost:5555");
        this.customers.add(new Customer("Jenson Button", 123));
        this.customers.add(new Customer("Michael Schumacker", 456));
        this.customers.add(new Customer("Juan Pablo Montoya", 789));
        this.customers.add(new Customer("David Colthard", 101));
        this.customers.add(new Customer("Rubens Barrichello", 112));
        this.customers.add(new Customer("Mark Webber", 131));
        this.customers.add(new Customer("Takuma Sato", 415));
        this.customers.add(new Customer("Kimi Raikkonen", 161));
        this.customers.add(new Customer("Ralf Schumacher", 718));
        this.customers.add(new Customer("Jarno Trulli", 192));
    }

    protected ConfigurationBuilder getConfigBuilder() throws MuleException {
        return new SpringXmlConfigurationBuilder(this.config);
    }

    protected void dispose() throws Exception {
        this.remoteClient.dispose();
    }

    protected void run(boolean synchronous) throws Exception {
        int response = 0;
        block6: while (response != 113) {
            System.out.println("\n" + LocaleMessage.menu());
            response = AbstractLoanBrokerApp.readCharacter();
            switch (response) {
                case 49: {
                    CustomerQuoteRequest request = AbstractLoanBrokerApp.getRequestFromUser();
                    this.request(request, synchronous);
                    continue block6;
                }
                case 50: {
                    this.sendRandomRequests(100, synchronous);
                    continue block6;
                }
                case 51: {
                    System.out.println(LocaleMessage.menuOptionNumberOfRequests());
                    int number = AbstractLoanBrokerApp.readInt();
                    if (number < 1) {
                        System.out.println(LocaleMessage.menuErrorNumberOfRequests());
                        continue block6;
                    }
                    this.sendRandomRequests(number, synchronous);
                    continue block6;
                }
                case 113: {
                    System.out.println(LocaleMessage.exiting());
                    this.dispose();
                    System.exit(0);
                    continue block6;
                }
            }
            System.out.println(LocaleMessage.menuError());
        }
    }

    public CustomerQuoteRequest createRequest() {
        int index = new Double(Math.random() * 10.0).intValue();
        Customer c = this.customers.get(index);
        return new CustomerQuoteRequest(c, AbstractLoanBrokerApp.getRandomAmount(), AbstractLoanBrokerApp.getRandomDuration());
    }

    protected static CustomerQuoteRequest getRequestFromUser() throws IOException {
        byte[] buf = new byte[128];
        System.out.print(LocaleMessage.enterName());
        System.in.read(buf);
        String name = new String(buf).trim();
        System.out.print(LocaleMessage.enterLoanAmount());
        buf = new byte[16];
        System.in.read(buf);
        String amount = new String(buf).trim();
        System.out.print(LocaleMessage.enterLoanDuration());
        buf = new byte[16];
        System.in.read(buf);
        String duration = new String(buf).trim();
        int d = 0;
        try {
            d = Integer.parseInt(duration);
        }
        catch (NumberFormatException e) {
            System.out.println(LocaleMessage.loanDurationError(duration));
            d = AbstractLoanBrokerApp.getRandomDuration();
        }
        double a = 0.0;
        try {
            a = Double.valueOf(amount);
        }
        catch (NumberFormatException e) {
            System.out.println(LocaleMessage.loanAmountError(amount));
            a = AbstractLoanBrokerApp.getRandomAmount();
        }
        Customer c = new Customer(name, AbstractLoanBrokerApp.getRandomSsn());
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, a, d);
        return request;
    }

    public void request(CustomerQuoteRequest request, boolean sync) throws Exception {
        if (!sync) {
            this.remoteClient.dispatchRemote("CustomerRequests", (Object)request, null);
            System.out.println(LocaleMessage.sentAsync());
            Thread.sleep(3000L);
        } else {
            MuleMessage result = this.remoteClient.sendRemote("CustomerRequests", (Object)request, null);
            if (result == null) {
                System.out.println(LocaleMessage.requestError());
            } else {
                System.out.println(LocaleMessage.requestResponse(result.getPayload()));
            }
        }
    }

    public void requestDispatch(int number, String endpoint) throws Exception {
        for (int i = 0; i < number; ++i) {
            this.remoteClient.dispatchRemote(endpoint, (Object)this.createRequest(), null);
        }
    }

    public List<Object> requestSend(int number, String endpoint) throws Exception {
        ArrayList<Object> results = new ArrayList<Object>(number);
        for (int i = 0; i < number; ++i) {
            MuleMessage result = this.remoteClient.sendRemote(endpoint, (Object)this.createRequest(), null);
            if (result == null) continue;
            results.add(result.getPayload());
        }
        return results;
    }

    protected void sendRandomRequests(int number, boolean synchronous) throws Exception {
        if (synchronous) {
            List<Object> list = this.requestSend(number, "CustomerRequests");
            int i = 1;
            System.out.println("sendRandomRequests");
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                System.out.println("sendRandomRequests results :" + LocaleMessage.request(i, iterator.next().toString()));
                ++i;
            }
        } else {
            this.requestDispatch(number, "CustomerRequests");
            System.out.println(LocaleMessage.sentAsync());
        }
    }

    protected static int readCharacter() throws IOException {
        byte[] buf = new byte[16];
        System.in.read(buf);
        return buf[0];
    }

    protected static String readString() throws IOException {
        byte[] buf = new byte[80];
        System.in.read(buf);
        return new String(buf).trim();
    }

    protected static int readInt() throws IOException {
        try {
            return Integer.parseInt(AbstractLoanBrokerApp.readString());
        }
        catch (NumberFormatException nfex) {
            return 0;
        }
    }

    protected static double getRandomAmount() {
        return Math.round(Math.random() * 18000.0);
    }

    protected static int getRandomDuration() {
        return new Double(Math.random() * 60.0).intValue();
    }

    protected static int getRandomSsn() {
        return new Double(Math.random() * 6000.0).intValue();
    }
}

