/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.loanbroker;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.example.loanbroker.LoanBrokerException;
import org.mule.example.loanbroker.LoanBrokerService;
import org.mule.example.loanbroker.LocaleMessage;
import org.mule.example.loanbroker.messages.CreditProfile;
import org.mule.example.loanbroker.messages.Customer;
import org.mule.example.loanbroker.messages.CustomerQuoteRequest;
import org.mule.example.loanbroker.messages.LoanBrokerQuoteRequest;
import org.mule.example.loanbroker.messages.LoanQuote;

public class DefaultLoanBroker
implements LoanBrokerService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AtomicInteger quotes = new AtomicInteger(0);
    private final AtomicInteger requests = new AtomicInteger(0);
    private final AtomicInteger profiles = new AtomicInteger(0);

    @Override
    public Object getLoanQuote(CustomerQuoteRequest request) throws LoanBrokerException {
        int requests = this.incRequests();
        if (this.logger.isInfoEnabled()) {
            String[] params = new String[]{String.valueOf(requests), request.getCustomer().getName(), String.valueOf(request.getCustomer().getSsn()), String.valueOf(request.getLoanAmount()), String.valueOf(request.getLoanDuration())};
            this.logger.info((Object)("\n***** " + LocaleMessage.receivedRequest(params)));
        }
        return request;
    }

    public LoanBrokerQuoteRequest receiveLoanBrokerQuoteRequest(LoanBrokerQuoteRequest request) {
        return request;
    }

    public Customer receiveCustomer(Customer customer) {
        return customer;
    }

    public Object receiveCreditProfile(CreditProfile profile) {
        int profiles = this.incProfiles();
        if (this.logger.isInfoEnabled()) {
            String[] params = new String[]{String.valueOf(profiles), String.valueOf(profile.getCreditScore()), String.valueOf(profile.getCreditHistory())};
            this.logger.info((Object)("\n***** " + LocaleMessage.receivedProfile(params)));
        }
        return profile;
    }

    @Override
    public Object receiveQuote(LoanQuote quote) {
        int quotes = this.incQuotes();
        if (this.logger.isInfoEnabled()) {
            String[] params = new String[]{String.valueOf(quotes), quote.toString()};
            this.logger.info((Object)("\n***** " + LocaleMessage.receivedQuote(params)));
        }
        return quote;
    }

    protected int incQuotes() {
        return this.quotes.incrementAndGet();
    }

    protected int incRequests() {
        return this.requests.incrementAndGet();
    }

    protected int incProfiles() {
        return this.profiles.incrementAndGet();
    }
}

