/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.loanbroker.transformers;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.example.loanbroker.messages.CreditProfile;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class CreditProfileXmlToCreditProfile
extends AbstractTransformer {
    public CreditProfileXmlToCreditProfile() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.create(Document.class));
        this.setReturnDataType(DataTypeFactory.create(CreditProfile.class));
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        Document doc = null;
        if (src instanceof Document) {
            doc = (Document)src;
        } else {
            try {
                doc = DocumentHelper.parseText((String)src.toString());
            }
            catch (DocumentException e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
        }
        String history = doc.valueOf("/credit-profile/customer-history");
        String score = doc.valueOf("/credit-profile/credit-score");
        CreditProfile cp = new CreditProfile();
        cp.setCreditHistory(Integer.valueOf(history));
        cp.setCreditScore(Integer.valueOf(score));
        return cp;
    }
}

