/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.loanbroker.bank;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.example.loanbroker.LocaleMessage;
import org.mule.example.loanbroker.bank.BankService;
import org.mule.example.loanbroker.messages.LoanBrokerQuoteRequest;
import org.mule.example.loanbroker.messages.LoanQuote;

public class Bank
implements ServiceAware,
Serializable,
BankService {
    private static final long serialVersionUID = 4108271137166107769L;
    protected static final Log logger = LogFactory.getLog(Bank.class);
    private String bankName;
    private double primeRate = Math.random() * 10.0;
    private String endpoint;

    public Bank() {
    }

    public Bank(String bankname) {
        this();
        this.endpoint = this.bankName = bankname;
    }

    public void setService(Service service) {
        this.bankName = service.getName();
        List endpoints = service.getInboundRouter().getEndpoints();
        if (endpoints == null || endpoints.size() != 1) {
            throw new IllegalArgumentException("Bank is expected to have exactly 1 incoming endpoint.");
        }
        this.endpoint = ((ImmutableEndpoint)endpoints.get(0)).getName();
    }

    public LoanQuote getLoanQuote(LoanBrokerQuoteRequest request) {
        LoanQuote quote = new LoanQuote();
        quote.setBankName(this.getBankName());
        quote.setInterestRate(this.primeRate);
        logger.info((Object)LocaleMessage.receivedRate(quote));
        return quote;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public double getPrimeRate() {
        return this.primeRate;
    }

    public void setPrimeRate(double primeRate) {
        this.primeRate = primeRate;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

