/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker.transformers;

import org.mule.examples.loanbroker.messages.Customer;
import org.mule.examples.loanbroker.messages.CustomerQuoteRequest;
import org.mule.transformers.AbstractMessageAwareTransformer;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class RestRequestToCustomerRequest
extends AbstractMessageAwareTransformer {
    public RestRequestToCustomerRequest() {
        this.setReturnClass(CustomerQuoteRequest.class);
    }

    public Object transform(UMOMessage message, String outputEncoding) throws TransformerException {
        int duration;
        double amount;
        int ssn;
        String name;
        try {
            name = this.getParam(message, "customerName");
            ssn = Integer.parseInt(this.getParam(message, "ssn"));
            amount = Double.parseDouble(this.getParam(message, "loanAmount"));
            duration = Integer.parseInt(this.getParam(message, "loanDuration"));
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
        Customer c = new Customer(name, ssn);
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, amount, duration);
        return request;
    }

    protected String getParam(UMOMessage message, String name) throws NullPointerException {
        String value = message.getStringProperty(name, null);
        if (value == null) {
            throw new IllegalArgumentException("Parameter '" + name + "' must be set on the request");
        }
        return value;
    }
}

