/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker.bank;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ConfigurationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.examples.loanbroker.LocaleMessage;
import org.mule.examples.loanbroker.bank.BankService;
import org.mule.examples.loanbroker.messages.LoanBrokerQuoteRequest;
import org.mule.examples.loanbroker.messages.LoanQuote;
import org.mule.impl.UMOComponentAware;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;

public class Bank
implements UMOComponentAware,
Serializable,
BankService {
    private static final long serialVersionUID = 4108271137166107769L;
    protected static final Log logger = LogFactory.getLog((Class)Bank.class);
    private String bankName;
    private double primeRate = Math.random() * 10.0;
    private String endpoint;

    public Bank() {
    }

    public Bank(String bankname) {
        this();
        this.endpoint = this.bankName = bankname;
    }

    public void setComponent(UMOComponent component) throws ConfigurationException {
        this.bankName = component.getName();
        List endpoints = component.getInboundRouter().getEndpoints();
        if (endpoints == null || endpoints.size() != 1) {
            throw new ConfigurationException(MessageFactory.createStaticMessage((String)"Bank is expected to have exactly 1 incoming endpoint."));
        }
        this.endpoint = ((UMOEndpoint)endpoints.get(0)).getName();
    }

    public LoanQuote getLoanQuote(LoanBrokerQuoteRequest request) {
        LoanQuote quote = new LoanQuote();
        quote.setBankName(this.getBankName());
        quote.setInterestRate(this.primeRate);
        logger.info((Object)LocaleMessage.receivedRate(quote));
        return quote;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public double getPrimeRate() {
        return this.primeRate;
    }

    public void setPrimeRate(double primeRate) {
        this.primeRate = primeRate;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

