/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker;

import java.io.IOException;
import org.mule.config.i18n.Message;
import org.mule.examples.loanbroker.messages.Customer;
import org.mule.examples.loanbroker.messages.CustomerQuoteRequest;

public abstract class AbstractMain {
    protected static int readCharacter() throws IOException {
        byte[] buf = new byte[16];
        System.in.read(buf);
        return buf[0];
    }

    protected static String readString() throws IOException {
        byte[] buf = new byte[80];
        System.in.read(buf);
        return new String(buf).trim();
    }

    protected static int readInt() throws IOException {
        try {
            return Integer.parseInt(AbstractMain.readString());
        }
        catch (NumberFormatException nfex) {
            return 0;
        }
    }

    protected static double getRandomAmount() {
        return Math.round(Math.random() * 18000.0);
    }

    protected static int getRandomDuration() {
        return new Double(Math.random() * 60.0).intValue();
    }

    protected static CustomerQuoteRequest getRequestFromUser() throws IOException {
        byte[] buf = new byte[128];
        System.out.print(new Message("loanbroker-example", 16).getMessage());
        System.in.read(buf);
        String name = new String(buf).trim();
        System.out.print(new Message("loanbroker-example", 17).getMessage());
        buf = new byte[16];
        System.in.read(buf);
        String amount = new String(buf).trim();
        System.out.print(new Message("loanbroker-example", 18).getMessage());
        buf = new byte[16];
        System.in.read(buf);
        String duration = new String(buf).trim();
        int d = 0;
        try {
            d = Integer.parseInt(duration);
        }
        catch (NumberFormatException e) {
            System.out.println(new Message("loanbroker-example", 19, (Object)duration).getMessage());
            d = AbstractMain.getRandomDuration();
        }
        double a = 0.0;
        try {
            a = Double.valueOf(amount);
        }
        catch (NumberFormatException e) {
            System.out.println(new Message("loanbroker-example", 20, (Object)amount).getMessage());
            a = AbstractMain.getRandomAmount();
        }
        Customer c = new Customer(name, AbstractMain.getRandomSsn());
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, a, d);
        return request;
    }

    protected static int getRandomSsn() {
        return new Double(Math.random() * 6000.0).intValue();
    }
}

