/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.loanbroker.tests;

import java.beans.ExceptionListener;
import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import org.apache.commons.lang.time.StopWatch;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.example.loanbroker.messages.Customer;
import org.mule.example.loanbroker.messages.CustomerQuoteRequest;
import org.mule.example.loanbroker.messages.LoanQuote;
import org.mule.example.loanbroker.tests.AbstractLoanBrokerTestCase;
import org.mule.module.client.MuleClient;
import org.mule.transport.NullPayload;
import org.mule.util.ExceptionHolder;
import org.mule.util.StringMessageUtils;

public abstract class AbstractAsynchronousLoanBrokerTestCase
extends AbstractLoanBrokerTestCase {
    @Override
    protected int getNumberOfRequests() {
        return 100;
    }

    protected int getDelay() {
        return 30000;
    }

    protected int getWarmUpMessages() {
        return 50;
    }

    @Override
    public void testSingleLoanRequest() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, 10000.0, 48);
        client.dispatch("CustomerRequests", (Object)request, null);
        MuleMessage result = client.request("CustomerResponses", (long)this.getDelay());
        AbstractAsynchronousLoanBrokerTestCase.assertNotNull((String)"Result is null", (Object)result);
        AbstractAsynchronousLoanBrokerTestCase.assertFalse((String)"Result is null", (boolean)(result.getPayload() instanceof NullPayload));
        AbstractAsynchronousLoanBrokerTestCase.assertTrue((String)("Result should be LoanQuote but is " + result.getPayload().getClass().getName()), (boolean)(result.getPayload() instanceof LoanQuote));
        LoanQuote quote = (LoanQuote)result.getPayload();
        AbstractAsynchronousLoanBrokerTestCase.assertTrue((quote.getInterestRate() > 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testLotsOfLoanRequests() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest[] requests = new CustomerQuoteRequest[]{new CustomerQuoteRequest(c, 100000.0, 48), new CustomerQuoteRequest(c, 1000.0, 12), new CustomerQuoteRequest(c, 10.0, 24)};
        StopWatch stopWatch = new StopWatch();
        int numRequests = this.getNumberOfRequests() + this.getWarmUpMessages();
        int i = 0;
        int numberOfThreads = 1;
        CountDownLatch latch = new CountDownLatch(numberOfThreads);
        ExceptionHolder exceptionHolder = new ExceptionHolder();
        try {
            for (int x = 0; x < numberOfThreads; ++x) {
                Thread thread = new Thread(new ClientReceiver(latch, numRequests / numberOfThreads, (ExceptionListener)exceptionHolder));
                thread.start();
            }
            for (i = 0; i < numRequests; ++i) {
                if (i == this.getWarmUpMessages()) {
                    stopWatch.start();
                }
                client.dispatch("CustomerRequests", (Object)requests[i % 3], null);
            }
        }
        finally {
            latch.await();
            stopWatch.stop();
            System.out.println("Total running time was: " + stopWatch.getTime() + "ms");
            System.out.println("Requests processed was: " + i);
            int mps = (int)((double)numRequests / ((double)stopWatch.getTime() / 1000.0));
            System.out.println("Msg/sec: " + mps + " (warm up msgs = " + this.getWarmUpMessages() + ")");
            if (exceptionHolder.isExceptionThrown()) {
                exceptionHolder.print();
                AbstractAsynchronousLoanBrokerTestCase.fail((String)"Exceptions thrown during async processing");
            }
        }
    }

    private class ClientReceiver
    implements Runnable {
        private CountDownLatch latch;
        private int numberOfRequests;
        private ExceptionListener exListener;

        public ClientReceiver(CountDownLatch latch, int numberOfRequests, ExceptionListener exListener) {
            this.latch = latch;
            this.numberOfRequests = numberOfRequests;
            this.exListener = exListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i = 0;
            try {
                MuleClient client = new MuleClient(muleContext);
                MuleMessage result = null;
                for (i = 0; i < this.numberOfRequests; ++i) {
                    try {
                        result = client.request("CustomerResponses", (long)AbstractAsynchronousLoanBrokerTestCase.this.getDelay());
                    }
                    catch (MuleException e) {
                        this.exListener.exceptionThrown((Exception)((Object)e));
                        break;
                    }
                    Assert.assertNotNull((String)"Result is null", (Object)result);
                    Assert.assertFalse((String)"Result is null", (boolean)(result.getPayload() instanceof NullPayload));
                    Assert.assertTrue((String)("Result should be LoanQuote but is " + result.getPayload().getClass().getName()), (boolean)(result.getPayload() instanceof LoanQuote));
                    LoanQuote quote = (LoanQuote)result.getPayload();
                    Assert.assertTrue((quote.getInterestRate() > 0.0 ? 1 : 0) != 0);
                }
            }
            catch (Throwable e) {
                System.out.println(StringMessageUtils.getBoilerPlate((String)("Processed Messages=" + i)));
                if (e instanceof Error) {
                    this.exListener.exceptionThrown(new Exception(e));
                } else {
                    this.exListener.exceptionThrown((Exception)e);
                }
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

