/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker.tests;

import org.mule.examples.loanbroker.messages.Customer;
import org.mule.examples.loanbroker.messages.CustomerQuoteRequest;
import org.mule.examples.loanbroker.tests.AbstractLoanBrokerTestCase;
import org.mule.extras.client.MuleClient;

public abstract class AbstractAsynchronousLoanBrokerTestCase
extends AbstractLoanBrokerTestCase {
    protected int getNumberOfRequests() {
        return 2;
    }

    protected int getDelay() {
        return 1000;
    }

    public void testSingleLoanRequest() throws Exception {
        MuleClient client = new MuleClient();
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, 100000.0, 48);
        client.dispatch("vm://customer.requests", (Object)request, null);
        Thread.sleep(this.getDelay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLotsOfLoanRequests() throws Exception {
        int i;
        MuleClient client = new MuleClient();
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest[] requests = new CustomerQuoteRequest[]{new CustomerQuoteRequest(c, 100000.0, 48), new CustomerQuoteRequest(c, 1000.0, 12), new CustomerQuoteRequest(c, 10.0, 24)};
        long start = System.currentTimeMillis();
        int numRequests = this.getNumberOfRequests();
        try {
            for (i = 0; i < numRequests; ++i) {
                CustomerQuoteRequest loanRequest = requests[i % 3];
                client.dispatch("vm://customer.requests", (Object)loanRequest, null);
            }
            Thread.sleep(this.getDelay() * numRequests);
        }
        finally {
            long el = System.currentTimeMillis() - start;
            System.out.println("Total running time was: " + el + "ms");
            System.out.println("Requests processed was: " + i);
            int mps = (int)((double)numRequests / ((double)el / 1000.0));
            System.out.println("Msg/sec: " + mps + " (no warm up)");
        }
    }
}

