/*
 * Decompiled with CFR 0.152.
 */
package org.mule.samples.hello;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.mule.samples.hello.NameString;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;

public class HttpRequestToNameString
extends AbstractTransformer {
    private static final String NAME_REQUEST_PARAMETER = "name=";

    public HttpRequestToNameString() {
        this.registerSourceType(String.class);
        this.registerSourceType([B.class);
        this.setReturnClass(NameString.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        return new NameString(this.extractNameValue(this.extractRequestQuery(this.convertRequestToString(src, encoding))));
    }

    private String convertRequestToString(Object src, String encoding) {
        String srcAsString = null;
        if (src instanceof byte[]) {
            if (encoding != null) {
                try {
                    srcAsString = new String((byte[])src, encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    srcAsString = new String((byte[])src);
                }
            } else {
                srcAsString = new String((byte[])src);
            }
        } else {
            srcAsString = src.toString();
        }
        return srcAsString;
    }

    private String extractRequestQuery(String request) {
        String requestQuery = null;
        if (request != null && request.length() > 0 && request.indexOf(63) != -1) {
            requestQuery = request.substring(request.indexOf(63) + 1).trim();
        }
        return requestQuery;
    }

    private String extractNameValue(String requestQuery) throws TransformerException {
        String nameValue = null;
        if (requestQuery != null && requestQuery.length() > 0) {
            int nameParameterPos = requestQuery.indexOf(NAME_REQUEST_PARAMETER);
            if (nameParameterPos != -1) {
                int nextParameterValuePos = requestQuery.indexOf(38);
                if (nextParameterValuePos == -1 || nextParameterValuePos < nameParameterPos) {
                    nextParameterValuePos = requestQuery.length();
                }
                nameValue = requestQuery.substring(nameParameterPos + NAME_REQUEST_PARAMETER.length(), nextParameterValuePos);
            }
            if (nameValue != null && nameValue.length() > 0) {
                try {
                    nameValue = URLDecoder.decode(nameValue, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    this.logger.error((Object)uee.getMessage());
                }
            }
        }
        if (nameValue == null) {
            nameValue = "";
        }
        return nameValue;
    }
}

