/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.BaseFormatter;
import com.mulesoft.lexical.formatstype.ClassPatternMatching;
import com.mulesoft.lexical.formatstype.ExpectedClass;
import com.mulesoft.lexical.formatstype.PadConverter;
import com.mulesoft.lexical.formatstype.SignConverterFunction;
import com.mulesoft.lexical.formatstype.SingleConverter;
import com.mulesoft.lexical.formatstype.TruncateConverter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.validation.LongLengthValidation;
import com.mulesoft.lexical.formatstype.validation.ShortLengthValidation;
import com.mulesoft.lexical.formatstype.validation.TruncateCondition;
import java.math.BigInteger;

public class IntegerFormatter
extends BaseFormatter<Number> {
    private static IntegerFormatter instance;

    public static IntegerFormatter getInstance() {
        if (instance == null) {
            instance = new IntegerFormatter();
        }
        return instance;
    }

    private IntegerFormatter() {
        this.withPatternMatching(new ExpectedClass<BigInteger>(BigInteger.class));
        this.withPatternMatching(new ClassPatternMatching<BigInteger>(new Class[]{Long.class, Integer.class}){

            @Override
            protected BigInteger apply(Object value) {
                return new BigInteger(value.toString());
            }
        });
        this.withOutputConverter(new PadConverter());
        this.withOutputConverter(new SingleConverter(new SignConverterFunction()));
        this.withOutputConverter(new TruncateConverter(true).withCondition(new TruncateCondition()));
        this.withValidation(new LongLengthValidation());
        this.withValidation(new ShortLengthValidation());
    }

    @Override
    protected BigInteger valueToUseForWrong(Object value, TypeBaseFormat typeFormat, ErrorHandler handler) {
        return null;
    }

    @Override
    protected BigInteger valueToUseForNull(TypeBaseFormat typeFormat, ErrorHandler handler) {
        return null;
    }

    @Override
    protected String doFormat(Number value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        return value.toString();
    }
}

