/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.FormatError;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.validation.FormatTypeFunction;

public class InvalidCharacterOnInteger
implements FormatTypeFunction<String, String> {
    @Override
    public String apply(String value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        int i;
        boolean trail = this.checkInReverseDirection(typeFormat);
        InvalidCharacterReview reviewObject = this.createReviewObject(handler);
        int n = i = trail ? value.length() - 1 : 0;
        while (trail ? i >= 0 : i < value.length()) {
            switch (value.charAt(i)) {
                case '-': {
                    this.checkSign('-', reviewObject, typeFormat.getNumberSign().useMinus() && reviewObject.newValueBuilder.length() == 0, typeFormat, handler);
                    break;
                }
                case '+': {
                    this.checkSign('+', reviewObject, typeFormat.getNumberSign().acceptPlus() && reviewObject.newValueBuilder.length() == 0, typeFormat, handler);
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    reviewObject.newValueBuilder.append(value.charAt(i));
                    break;
                }
                default: {
                    this.notIntegerChar(value.charAt(i), reviewObject, handler, typeFormat);
                }
            }
            if (trail) {
                --i;
                continue;
            }
            ++i;
        }
        this.finalChecks(reviewObject, trail, typeFormat, handler);
        return this.buildFinalString(reviewObject);
    }

    protected void finalChecks(InvalidCharacterReview reviewObject, boolean trail, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        if (reviewObject.signBuilder.length() == 1 && reviewObject.newValueBuilder.length() == 0) {
            FormatError.invalidCharacter(reviewObject.signBuilder.charAt(0), handler, typeFormat);
            reviewObject.signBuilder.deleteCharAt(0);
        }
        if (reviewObject.newValueBuilder.length() == 0) {
            FormatError.noValuePresent(handler, typeFormat);
        } else if (trail) {
            reviewObject.newValueBuilder.reverse();
        }
    }

    protected InvalidCharacterReview createReviewObject(ErrorHandler handler) {
        return new InvalidCharacterReview();
    }

    protected boolean checkInReverseDirection(TypeBaseFormat typeFormat) {
        return typeFormat.getNumberSign().trailingSign();
    }

    protected String buildFinalString(InvalidCharacterReview reviewObject) {
        return reviewObject.signBuilder.toString() + reviewObject.newValueBuilder.toString();
    }

    protected void notIntegerChar(char chr, InvalidCharacterReview reviewObject, ErrorHandler handler, TypeBaseFormat typeFormat) throws LexicalException {
        FormatError.invalidCharacter(chr, handler, typeFormat);
    }

    protected void checkSign(char sign, InvalidCharacterReview reviewObject, boolean allowed, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        if (!allowed) {
            FormatError.signNotAllowed(sign, handler, typeFormat);
        } else if (reviewObject.signBuilder.length() > 0) {
            FormatError.invalidCharacter(sign, handler, typeFormat);
        } else {
            reviewObject.signBuilder.append(sign);
        }
    }

    protected class InvalidCharacterReview {
        StringBuilder newValueBuilder = new StringBuilder();
        StringBuilder signBuilder = new StringBuilder();

        protected InvalidCharacterReview() {
        }
    }
}

