/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.CheckAllowedChars;
import com.mulesoft.lexical.formatstype.CompositeConverter;
import com.mulesoft.lexical.formatstype.SingleConverter;
import com.mulesoft.lexical.formatstype.StripConverter;
import com.mulesoft.lexical.formatstype.TruncateConverter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.validation.LenientCondition;
import com.mulesoft.lexical.formatstype.validation.LongLengthValidation;
import com.mulesoft.lexical.formatstype.validation.ShortLengthValidation;
import com.mulesoft.lexical.formatstype.validation.TruncateCondition;

public class StringConverter
extends CompositeConverter<String> {
    private static StringConverter instance;

    public static StringConverter getInstance() {
        if (instance == null) {
            instance = new StringConverter();
        }
        return instance;
    }

    private StringConverter() {
        super(true);
        TruncateConverter truncate = new TruncateConverter(false, false);
        truncate.addCondition(new LenientCondition().negate());
        truncate.addCondition(new TruncateCondition());
        this.addConverter(truncate);
        this.addConverter(new SingleConverter(new CheckAllowedChars()).withCondition((handler, typeFormat) -> typeFormat.checkAllowedCharacters()));
        this.addConverter(new StripConverter());
        this.addValidation(new ShortLengthValidation().withCondition(new LenientCondition().negate()));
        this.addValidation(new LongLengthValidation().withCondition(new LenientCondition().negate()));
    }

    @Override
    public String doConvert(String value, ErrorHandler handler, TypeBaseFormat typeFormat) throws LexicalException {
        return value;
    }
}

