/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.BaseFormatter;
import com.mulesoft.lexical.formatstype.ClassPatternMatching;
import com.mulesoft.lexical.formatstype.ExpectedClass;
import com.mulesoft.lexical.formatstype.PadConverter;
import com.mulesoft.lexical.formatstype.SignConverterFunction;
import com.mulesoft.lexical.formatstype.SingleConverter;
import com.mulesoft.lexical.formatstype.TruncateConverter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.validation.LongLengthValidation;
import com.mulesoft.lexical.formatstype.validation.ShortLengthValidation;
import com.mulesoft.lexical.formatstype.validation.TruncateCondition;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ImpliedDecimalFormatter
extends BaseFormatter<BigDecimal> {
    private static ImpliedDecimalFormatter instance;

    public static ImpliedDecimalFormatter getInstance() {
        if (instance == null) {
            instance = new ImpliedDecimalFormatter();
        }
        return instance;
    }

    private ImpliedDecimalFormatter() {
        this.withPatternMatching(new ExpectedClass<BigDecimal>(BigDecimal.class));
        this.withPatternMatching(new ClassPatternMatching<BigDecimal>(new Class[]{BigInteger.class, Long.class, Integer.class, Double.class, Float.class}){

            @Override
            protected BigDecimal apply(Object value) {
                return new BigDecimal(value.toString());
            }
        });
        this.withOutputConverter(new PadConverter());
        this.withOutputConverter(new SingleConverter(new SignConverterFunction()));
        this.withOutputConverter(new TruncateConverter(true).withCondition(new TruncateCondition()));
        this.withValidation(new LongLengthValidation());
        this.withValidation(new ShortLengthValidation());
    }

    @Override
    protected BigDecimal valueToUseForWrong(Object value, TypeBaseFormat typeFormat, ErrorHandler handler) {
        return null;
    }

    @Override
    protected BigDecimal valueToUseForNull(TypeBaseFormat typeFormat, ErrorHandler handler) {
        return null;
    }

    @Override
    protected String doFormat(BigDecimal value, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        BigDecimal multiplicand = new BigDecimal(10).pow(typeFormat.getDecimalPosition());
        BigInteger bigInt = value.multiply(multiplicand).toBigInteger();
        return bigInt.toString();
    }
}

