/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.FlatFileLexer;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.parameter.Mediator;
import com.mulesoft.flatfile.lexical.settings.FlatFileSettingKeys;
import com.mulesoft.flatfile.lexical.settings.SettingsKey;
import com.mulesoft.lexical.formatstype.StringConverter;
import com.mulesoft.lexical.formatstype.StringFormatter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import java.io.IOException;

public class GeneralStringFormat
extends TypeBaseFormat
implements Mediator {
    private TypeFormatConstants.FillMode mode;

    public GeneralStringFormat(String code, int min, int max, TypeFormatConstants.FillMode fill) {
        super(code, min, max, StringConverter.getInstance(), StringFormatter.getInstance());
        if (fill.numberOnly()) {
            throw new IllegalArgumentException("Numeric fill option not supported");
        }
        switch (fill) {
            case LEFT: {
                break;
            }
            case RIGHT: {
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid string format fill setting");
            }
        }
        this.mode = fill;
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.STRING;
    }

    @Override
    public char getFill() {
        return ' ';
    }

    @Override
    public TypeFormatConstants.FillMode getFillMode() {
        return this.mode;
    }

    @Override
    public boolean load(FlatFileLexer lexer, int quant) throws IOException {
        try {
            return lexer.load(this.maxLength(), quant);
        }
        catch (IOException exc) {
            if (!lexer.isLenient()) {
                throw exc;
            }
            return lexer.tokenBuilder().length() != 0;
        }
    }

    @Override
    public TypeFormat fixFormat(SettingsKey key, Object value) {
        switch ((FlatFileSettingKeys)key) {
            case MISSING_VALUES: {
                return new GeneralStringFormat(this.typeCode(), this.minLength(), this.minLength(), this.getFillMode());
            }
        }
        return this;
    }

    @Override
    public char getFillChar() {
        return this.getFill();
    }
}

