/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.lexical.formatstype;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.lexical.formatstype.FormatError;
import com.mulesoft.lexical.formatstype.InvalidCharacterOnInteger;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;

public class InvalidCharacterOnDecimal
extends InvalidCharacterOnInteger {
    @Override
    protected boolean checkInReverseDirection(TypeBaseFormat typeFormat) {
        return false;
    }

    @Override
    protected void checkSign(char sign, InvalidCharacterOnInteger.InvalidCharacterReview ro, boolean allowed, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        InvalidCharacterForDecimalReview reviewObject = (InvalidCharacterForDecimalReview)ro;
        if (reviewObject.signBuilder.length() == 0 && allowed && !typeFormat.getNumberSign().trailingSign()) {
            reviewObject.signBuilder.append(sign);
        } else if (reviewObject.exponentMarkPosition > 0 && reviewObject.newValueBuilder.length() == reviewObject.exponentMarkPosition && sign == '-') {
            reviewObject.newValueBuilder.append(sign);
            reviewObject.negateExponentPosition = reviewObject.newValueBuilder.length();
        } else if (!typeFormat.getNumberSign().trailingSign()) {
            FormatError.signNotAllowed(sign, handler, typeFormat);
        } else {
            if (reviewObject.trailSignPosition >= 0) {
                FormatError.signNotAllowed(sign, handler, typeFormat);
            }
            reviewObject.trailSignPosition = reviewObject.newValueBuilder.length();
            reviewObject.trailSign = sign;
        }
    }

    @Override
    protected void notIntegerChar(char chr, InvalidCharacterOnInteger.InvalidCharacterReview ro, ErrorHandler handler, TypeBaseFormat typeFormat) throws LexicalException {
        InvalidCharacterForDecimalReview reviewObject = (InvalidCharacterForDecimalReview)ro;
        if ((chr == 'e' || chr == 'E') && reviewObject.exponentMarkPosition < 0 && typeFormat.getAllowExponent()) {
            if (reviewObject.newValueBuilder.length() == 0) {
                FormatError.noValueBeforeExp(handler, typeFormat);
                reviewObject.newValueBuilder.append("0E");
            } else {
                reviewObject.newValueBuilder.append("E");
            }
            reviewObject.exponentMarkPosition = reviewObject.newValueBuilder.length();
        } else if ((chr == '.' || chr == reviewObject.altmark) && reviewObject.decimalPointPosition < 0 && reviewObject.exponentMarkPosition < 0) {
            reviewObject.newValueBuilder.append(".");
            reviewObject.decimalPointPosition = reviewObject.newValueBuilder.length();
        } else {
            super.notIntegerChar(chr, ro, handler, typeFormat);
        }
    }

    @Override
    protected InvalidCharacterOnInteger.InvalidCharacterReview createReviewObject(ErrorHandler handler) {
        return new InvalidCharacterForDecimalReview(handler);
    }

    @Override
    protected void finalChecks(InvalidCharacterOnInteger.InvalidCharacterReview ro, boolean trail, TypeBaseFormat typeFormat, ErrorHandler handler) throws LexicalException {
        InvalidCharacterForDecimalReview reviewObject = (InvalidCharacterForDecimalReview)ro;
        if (typeFormat.getNumberSign().trailingSign() && reviewObject.trailSignPosition >= 0) {
            if (reviewObject.trailSignPosition == reviewObject.newValueBuilder.length()) {
                reviewObject.signBuilder.append(reviewObject.trailSign);
            } else {
                FormatError.signNotAllowed(reviewObject.trailSign, handler, typeFormat);
            }
        }
        if (reviewObject.newValueBuilder.length() == 0 || reviewObject.newValueBuilder.toString().startsWith("0E") || reviewObject.newValueBuilder.toString().equals(".") || reviewObject.newValueBuilder.toString().equals("-.")) {
            FormatError.noValuePresent(handler, typeFormat);
            reviewObject.newValueBuilder.setLength(0);
            reviewObject.newValueBuilder.append("0");
        } else {
            char lastChar = reviewObject.newValueBuilder.charAt(reviewObject.newValueBuilder.length() - 1);
            if (lastChar == 'E' || lastChar == '.' || lastChar == '-') {
                reviewObject.newValueBuilder.append("0");
            }
        }
        super.finalChecks(reviewObject, trail, typeFormat, handler);
    }

    protected class InvalidCharacterForDecimalReview
    extends InvalidCharacterOnInteger.InvalidCharacterReview {
        private int decimalPointPosition = -1;
        private int exponentMarkPosition = -1;
        private int negateExponentPosition = -1;
        private int trailSignPosition = -1;
        private char trailSign = (char)32;
        private int altmark = -1;

        protected InvalidCharacterForDecimalReview(ErrorHandler handler) {
            if (handler instanceof LexerBase) {
                this.altmark = ((LexerBase)handler).getAltDecimalMark();
            }
        }
    }
}

