/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.TypeFormatBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public abstract class NumberFormatBase
extends TypeFormatBase {
    protected final TypeFormatConstants.NumberSign signType;
    protected final boolean countSign;
    protected final TypeFormatConstants.FillMode fillMode;
    protected final char fillChar;

    public NumberFormatBase(String code, int min, int max, TypeFormatConstants.NumberSign sign, boolean count, TypeFormatConstants.FillMode pad, char fill) {
        super(code, min, max);
        this.signType = sign;
        this.countSign = count;
        this.fillMode = pad;
        this.fillChar = fill;
        if (this.fillMode == TypeFormatConstants.FillMode.ZEROES && this.fillChar != '0') {
            throw new IllegalStateException("FillMode ZEROES can only be used with fill character '0' ('" + fill + "' not allowed)");
        }
    }

    protected int stripPadding(LexerBase lexer, TypeFormatConstants.FillMode mode, char fill) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        int start = builder.length();
        switch (mode) {
            case RIGHT: {
                NumberFormatBase.stripSpaceLeft(fill, builder);
                break;
            }
            case LEFT: {
                NumberFormatBase.stripSpaceRight(fill, builder);
                break;
            }
        }
        int spaces = start - builder.length();
        if (builder.length() == 0) {
            this.noValuePresent(lexer);
            builder.append('0');
        }
        return spaces;
    }

    protected void missingRequiredSign(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "missing required sign");
    }

    protected void plusNotAllowed(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "plus sign (+) not allowed");
        lexer.tokenBuilder().delete(0, 1);
    }

    protected void minusNotAllowed(LexerBase lexer) throws LexicalException {
        lexer.error(this, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "minus sign (-) not allowed");
        lexer.tokenBuilder().delete(0, 1);
    }

    protected boolean signToNormalForm(LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        boolean signed = false;
        int index = this.signType.trailingSign() ? builder.length() - 1 : 0;
        char chr = builder.charAt(index);
        if (chr == '-') {
            if (this.signType.useMinus()) {
                signed = true;
            } else {
                this.minusNotAllowed(lexer);
                builder.deleteCharAt(index);
            }
        } else if (chr == '+') {
            if (this.signType.acceptPlus()) {
                signed = true;
            } else {
                this.plusNotAllowed(lexer);
                builder.deleteCharAt(index);
            }
        } else if (this.signType.forceSign()) {
            this.missingRequiredSign(lexer);
        }
        if (signed && this.signType.trailingSign()) {
            builder.deleteCharAt(index);
            builder.insert(0, chr);
        }
        return signed;
    }

    protected void validateLength(int length, LexerBase lexer) throws LexicalException {
        if (length < this.minLength) {
            this.tooShort(length, lexer);
        }
        if (length > this.maxLength) {
            this.tooLong(length, lexer);
            lexer.tokenBuilder().setLength(this.maxLength);
        }
    }

    protected int checkIntegerFormat(LexerBase lexer, TypeFormatConstants.FillMode mode, char fill) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        int spaces = this.stripPadding(lexer, mode, fill);
        int digits = 0;
        boolean number = false;
        for (int index = (signed = this.signToNormalForm(lexer)) ? 1 : 0; index < builder.length(); ++index) {
            char chr = builder.charAt(index);
            if (chr >= '0' && chr <= '9') {
                number = true;
                if (digits <= 0 && chr == '0') continue;
                ++digits;
                continue;
            }
            this.invalidCharacter(chr, lexer);
            builder.deleteCharAt(index--);
        }
        if (!number) {
            this.noValuePresent(lexer);
            lexer.tokenBuilder().append('0');
        } else {
            boolean signed;
            int length = builder.length() - (!this.countSign && signed ? 1 : 0) + spaces;
            this.validateLength(length, lexer);
        }
        return digits;
    }

    protected Object convertSizedInteger(LexerBase lexer, int digits) {
        String text = lexer.token();
        if (digits < 10) {
            return Integer.valueOf(text);
        }
        if (digits < 20) {
            return Long.valueOf(text);
        }
        return new BigInteger(text);
    }

    protected Object convertPlainDecimal(LexerBase lexer) throws LexicalException {
        char last;
        StringBuilder builder = lexer.tokenBuilder();
        this.stripPadding(lexer, this.fillMode, this.fillChar);
        boolean signed = this.signToNormalForm(lexer);
        boolean number = false;
        int digits = 0;
        boolean decimal = false;
        int altmark = lexer.getAltDecimalMark();
        for (int index = signed ? 1 : 0; index < builder.length(); ++index) {
            char chr = builder.charAt(index);
            if (chr >= '0' && chr <= '9') {
                number = true;
                if (digits <= 0 && chr == '0') continue;
                ++digits;
                continue;
            }
            if (!(decimal || chr != '.' && chr != altmark)) {
                decimal = true;
                if (chr != altmark) continue;
                builder.setCharAt(index, '.');
                continue;
            }
            if (index == 0 && signed) continue;
            this.invalidCharacter(chr, lexer);
            builder.deleteCharAt(index--);
        }
        if (!number) {
            this.noValuePresent(lexer);
            builder.append('0');
        }
        if (!decimal) {
            lexer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "missing required decimal mark");
        }
        if ((last = builder.charAt(builder.length() - 1)) == '.' || last == altmark) {
            builder.deleteCharAt(builder.length() - 1);
            return this.convertSizedInteger(lexer, digits);
        }
        return new BigDecimal(lexer.token());
    }

    protected void writePadded(String text, int length, boolean negate, WriterBase writer) throws IOException {
        int effect = length;
        if (this.signType == TypeFormatConstants.NumberSign.UNSIGNED && negate) {
            writer.error(this, ErrorHandler.ErrorCondition.INVALID_VALUE, "negative value not allowed");
            negate = false;
        }
        if (this.countSign) {
            switch (this.signType) {
                case ALWAYS_LEFT: 
                case ALWAYS_RIGHT: {
                    ++effect;
                    break;
                }
                default: {
                    if (!negate) break;
                    ++effect;
                }
            }
        }
        if (effect > this.maxLength) {
            this.tooLong(effect, writer);
            int trim = Math.max(text.length() - effect + this.maxLength, 0);
            text = text.substring(0, trim);
            effect = this.maxLength;
        }
        int pad = this.minLength - effect;
        if (this.fillMode == TypeFormatConstants.FillMode.ZEROES) {
            switch (this.signType) {
                case ALWAYS_LEFT: {
                    writer.writeEscaped(negate ? "-" : "+");
                    break;
                }
                case NEGATIVE_ONLY: 
                case OPTIONAL: {
                    if (!negate) break;
                    writer.writeEscaped("-");
                    break;
                }
            }
            NumberFormatBase.writePadding(pad, '0', writer);
            writer.writeEscaped(text);
            if (this.signType == TypeFormatConstants.NumberSign.ALWAYS_RIGHT) {
                writer.writeEscaped(negate ? "-" : "+");
            }
        } else {
            if (this.fillMode == TypeFormatConstants.FillMode.RIGHT) {
                NumberFormatBase.writePadding(pad, this.fillChar, writer);
            }
            switch (this.signType) {
                case ALWAYS_LEFT: {
                    writer.writeEscaped(negate ? "-" : "+");
                    writer.writeEscaped(text);
                    break;
                }
                case ALWAYS_RIGHT: {
                    writer.writeEscaped(text);
                    writer.writeEscaped(negate ? "-" : "+");
                    break;
                }
                case NEGATIVE_ONLY: 
                case OPTIONAL: {
                    if (negate) {
                        writer.writeEscaped("-");
                    }
                    writer.writeEscaped(text);
                    break;
                }
                case UNSIGNED: {
                    writer.writeEscaped(text);
                }
            }
            if (this.fillMode == TypeFormatConstants.FillMode.LEFT) {
                NumberFormatBase.writePadding(pad, this.fillChar, writer);
            }
        }
    }

    protected void writePadded(String text, boolean negate, WriterBase writer) throws IOException {
        this.writePadded(text, text.length(), negate, writer);
    }

    protected void writeBigInteger(BigInteger big, WriterBase writer) throws IOException {
        if (big.signum() < 0) {
            this.writePadded(big.abs().toString(), true, writer);
        } else {
            this.writePadded(big.toString(), false, writer);
        }
    }

    private static String appendSuffix(String text, String suffix) {
        if (suffix == null) {
            return text;
        }
        return text + suffix;
    }

    protected void writeIntegerValue(Object value, String suffix, WriterBase writer) throws IOException {
        if (value instanceof Integer) {
            int actual = (Integer)value;
            if (actual < 0) {
                this.writePadded(NumberFormatBase.appendSuffix(Integer.toString(-actual), suffix), true, writer);
            } else {
                this.writePadded(NumberFormatBase.appendSuffix(Integer.toString(actual), suffix), false, writer);
            }
        } else if (value instanceof Long) {
            long actual = (Long)value;
            if (actual < 0L) {
                this.writePadded(NumberFormatBase.appendSuffix(Long.toString(-actual), suffix), true, writer);
            } else {
                this.writePadded(NumberFormatBase.appendSuffix(Long.toString(actual), suffix), false, writer);
            }
        } else if (value instanceof BigInteger) {
            BigInteger actual = (BigInteger)value;
            if (actual.signum() < 0) {
                this.writePadded(NumberFormatBase.appendSuffix(actual.abs().toString(), suffix), true, writer);
            } else {
                this.writePadded(NumberFormatBase.appendSuffix(actual.toString(), suffix), false, writer);
            }
        } else {
            this.wrongType(value, writer);
        }
    }

    protected void writeIntegerValue(Object value, WriterBase writer) throws IOException {
        this.writeIntegerValue(value, null, writer);
    }

    protected void writeDecimalValue(Object value, WriterBase writer) throws IOException {
        if (value instanceof BigDecimal || value instanceof Double) {
            BigDecimal big = this.convertDoubleAndCastToBigDecimal(value);
            int precision = big.precision();
            int scale = big.scale();
            if (scale <= 0 && precision - scale <= this.maxLength) {
                this.writeIntegerValue(big.toBigIntegerExact(), ".", writer);
            } else {
                boolean negate;
                boolean bl = negate = big.signum() < 0;
                if (negate) {
                    big = big.abs();
                }
                if (scale >= 0 && Math.max(precision, scale) <= this.maxLength) {
                    String text = big.toPlainString();
                    if (text.length() > 1 && text.charAt(0) == '0') {
                        text = text.substring(1);
                    }
                    this.writePadded(text, text.length(), negate, writer);
                } else {
                    int allowed = this.maxLength - 1 - (negate && this.countSign ? 1 : 0);
                    if (allowed + scale < 0) {
                        writer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "value representation not possible for " + ((BigDecimal)value).toString());
                        this.writePadded("0", 1, false, writer);
                    } else {
                        writer.error(this, ErrorHandler.ErrorCondition.DATA_TRUNCATION, "rounding value to fit " + ((BigDecimal)value).toString());
                        MathContext mc = new MathContext(allowed);
                        big.round(mc);
                        String text = big.toPlainString();
                        if (text.length() > 1 && text.charAt(0) == '0') {
                            text = text.substring(1);
                        }
                        this.writePadded(text, text.length(), negate, writer);
                    }
                }
            }
        } else {
            this.writeIntegerValue(value, ".", writer);
        }
    }

    protected BigDecimal convertDoubleAndCastToBigDecimal(Object value) {
        if (value instanceof Double) {
            value = BigDecimal.valueOf((Double)value);
        }
        return (BigDecimal)value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NumberFormatBase && super.equals(obj)) {
            NumberFormatBase other = (NumberFormatBase)obj;
            return this.countSign == other.countSign && this.fillMode == other.fillMode && this.signType == other.signType;
        }
        return false;
    }
}

