/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.lexical.formatstype.BaseFormatter;
import com.mulesoft.lexical.formatstype.IntegerConverter;
import com.mulesoft.lexical.formatstype.IntegerFormatter;
import com.mulesoft.lexical.formatstype.TypeBaseFormat;
import com.mulesoft.lexical.formatstype.TypeFormatConverter;

public class IntegerFormat<A extends Number>
extends TypeBaseFormat<A> {
    private TypeFormatConstants.NumberSign signType;
    private boolean countSign;
    private TypeFormatConstants.FillMode fillMode;

    public IntegerFormat(String code, int min, int max, TypeFormatConstants.NumberSign sign, boolean count, TypeFormatConstants.FillMode mode) {
        this(code, min, max, sign, count, mode, IntegerConverter.getInstance(), IntegerFormatter.getInstance());
    }

    public IntegerFormat(String code, int min, int max, TypeFormatConstants.NumberSign sign, boolean count, TypeFormatConstants.FillMode mode, TypeFormatConverter<Number, String> converter, BaseFormatter<Number> formatter) {
        super(code, min, max, converter, formatter);
        this.signType = sign;
        this.countSign = count;
        this.fillMode = mode;
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.INTEGER;
    }

    @Override
    public char getFill() {
        return '0';
    }

    @Override
    public TypeFormatConstants.FillMode getFillMode() {
        return this.fillMode;
    }

    @Override
    public TypeFormatConstants.NumberSign getNumberSign() {
        return this.signType;
    }

    protected int addedSignToValue(String value) {
        return this.countSign ? 0 : (this.trailedSign(value) + this.initSign(value)).length();
    }

    protected String initSign(String value) {
        if (value.length() > 0 && (value.charAt(0) == '-' || value.charAt(0) == '+')) {
            return Character.toString(value.charAt(0));
        }
        return "";
    }

    protected boolean getCountSign() {
        return this.countSign;
    }

    @Override
    public String truncateToMaxLength(String value) {
        if (this.countSign) {
            return super.truncateToMaxLength(value);
        }
        String initSign = this.initSign(value);
        if (initSign.length() > 0) {
            return initSign + super.truncateToMaxLength(value.substring(1));
        }
        return super.truncateToMaxLength(value) + this.trailedSign(value);
    }

    protected String trailedSign(String value) {
        int i = value.length() - 1;
        if (i >= 0 && (value.charAt(i) == '-' || value.charAt(i) == '+')) {
            return Character.toString(value.charAt(i));
        }
        return "";
    }

    @Override
    public int minLength(String value) {
        return super.minLength() + this.addedSignToValue(value);
    }

    @Override
    public int maxLength(String value) {
        return super.maxLength(value) + this.addedSignToValue(value);
    }
}

