/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.lexical.ErrorHandler;
import com.anypoint.df.edi.lexical.LexicalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public abstract class LexerBase {
    protected final Logger logger = Logger.getLogger(this.getClass());
    final InputStream stream;
    Reader reader;
    ErrorHandler errorHandler;
    int altDecimalMark;
    int groupCount;
    int segmentNumber;
    int elementNumber;
    EdiConstants.ItemType currentType;
    StringBuilder tokenBuilder;
    String segmentTag;

    public LexerBase(InputStream is) {
        this.stream = is;
        this.altDecimalMark = -1;
        this.tokenBuilder = new StringBuilder();
    }

    public void setHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    abstract void handleError(EdiConstants.DataType var1, ErrorHandler.ErrorCondition var2, String var3) throws LexicalException;

    public abstract void discardTo(EdiConstants.ItemType var1) throws IOException;

    public void discardSegment() throws IOException {
        this.discardTo(EdiConstants.ItemType.SEGMENT);
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable t) {}
        } else {
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void readArray(byte[] byts, int from) throws IOException {
        int count;
        for (int offset = from; byts.length > offset; offset += count) {
            count = this.stream.read(byts, offset, byts.length - offset);
            if (count > 0) continue;
            throw new IOException("Required data missing from message");
        }
    }

    byte[] readBytes(int num) throws IOException {
        byte[] byts = new byte[num];
        this.readArray(byts, 0);
        return byts;
    }

    public void countGroup() {
        ++this.groupCount;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    public String segmentTag() {
        return this.segmentTag;
    }

    public EdiConstants.ItemType currentType() {
        return this.currentType;
    }

    public String token() {
        return this.tokenBuilder.toString();
    }

    public void checkLength(EdiConstants.DataType type, int length, int minl, int maxl) throws LexicalException {
        if (length < minl) {
            this.handleError(type, ErrorHandler.ErrorCondition.TOO_SHORT, "effective length " + length + " is less than " + minl);
        } else if (length > maxl) {
            this.handleError(type, ErrorHandler.ErrorCondition.TOO_LONG, "effective length " + length + " is greater than " + maxl);
        }
    }

    public void checkLength(EdiConstants.DataType type, int minl, int maxl) throws LexicalException {
        this.checkLength(type, this.tokenBuilder.length(), minl, maxl);
    }

    public String parseAlpha(int minl, int maxl) throws IOException {
        int length = this.tokenBuilder.length();
        this.checkLength(EdiConstants.DataType.ALPHA, length, minl, maxl);
        int lastns = -1;
        for (int i = 0; i < length; ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (chr >= '0' && chr <= '9') {
                this.handleError(EdiConstants.DataType.ALPHA, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
                continue;
            }
            if (chr == ' ') continue;
            lastns = i;
        }
        return this.tokenBuilder.substring(0, lastns + 1);
    }

    int checkInteger() throws LexicalException {
        int length = this.tokenBuilder.length();
        int digits = 0;
        for (int i = 0; i < length; ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (chr >= '0' && chr <= '9') {
                if (digits <= 0 && chr == '0') continue;
                ++digits;
                continue;
            }
            if (i == 0 && chr == '-') continue;
            this.handleError(EdiConstants.DataType.INTEGER, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        return digits;
    }

    public Integer parseInteger(int minl, int maxl) throws IOException {
        this.checkInteger();
        int length = this.tokenBuilder.length();
        if (length > 0 && this.tokenBuilder.charAt(0) == '-') {
            --length;
        }
        this.checkLength(EdiConstants.DataType.INTEGER, length, minl, maxl);
        return Integer.valueOf(this.tokenBuilder.toString());
    }

    Object sizedInt(int digits) {
        String text = this.tokenBuilder.toString();
        if (digits < 10) {
            return Integer.valueOf(text);
        }
        if (digits < 20) {
            return Long.valueOf(text);
        }
        return new BigInteger(text);
    }

    public Object parseBigInteger(int minl, int maxl) throws IOException {
        int digits = this.checkInteger();
        int length = this.tokenBuilder.length();
        if (length > 0 && this.tokenBuilder.charAt(0) == '-') {
            --length;
        }
        this.checkLength(EdiConstants.DataType.INTEGER, length, minl, maxl);
        return this.sizedInt(digits);
    }

    public Object parseBigDecimal(int minl, int maxl) throws IOException {
        int length = this.tokenBuilder.length();
        int actual = 0;
        int digits = 0;
        boolean decimal = false;
        int exponent = -1;
        for (int i = 0; i < length; ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (chr >= '0' && chr <= '9') {
                ++actual;
                if (digits <= 0 && chr == '0') continue;
                ++digits;
                continue;
            }
            if (!(decimal || chr != '.' && chr != this.altDecimalMark)) {
                decimal = true;
                if (chr != this.altDecimalMark) continue;
                this.tokenBuilder.setCharAt(i, '.');
                continue;
            }
            if (exponent < 0 && (chr == 'E' || chr == 'e')) {
                exponent = i;
                continue;
            }
            if ((i == 0 || i == exponent + 1) && chr == '-') continue;
            this.handleError(EdiConstants.DataType.REAL, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed or wrong placement");
        }
        this.checkLength(EdiConstants.DataType.REAL, actual, minl, maxl);
        if (exponent >= 0) {
            BigDecimal base = new BigDecimal(this.tokenBuilder.substring(0, exponent));
            int power = Integer.valueOf(this.tokenBuilder.substring(exponent + 1));
            return base.scaleByPowerOfTen(power);
        }
        if (decimal) {
            return new BigDecimal(this.tokenBuilder.toString());
        }
        return this.sizedInt(digits);
    }

    public Object parseUnscaledNumber(int minl, int maxl) throws IOException {
        int length = this.tokenBuilder.length();
        int digits = 0;
        boolean decimal = false;
        for (int i = 0; i < length; ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (chr >= '0' && chr <= '9') {
                ++digits;
                continue;
            }
            if (!decimal && chr == '.') {
                decimal = true;
                continue;
            }
            if (i == 0 && (chr == '+' || chr == '-')) continue;
            this.handleError(EdiConstants.DataType.REAL, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed or wrong placement");
        }
        this.checkLength(EdiConstants.DataType.REAL, digits, minl, maxl);
        if (decimal) {
            return new BigDecimal(this.tokenBuilder.toString());
        }
        return this.sizedInt(digits);
    }

    public Calendar parseDate(int minl, int maxl) throws IOException {
        int year;
        int length = this.tokenBuilder.length();
        if (length != 6 && length != 8) {
            this.handleError(EdiConstants.DataType.DATE, ErrorHandler.ErrorCondition.INVALID_DATE, "date value must be either 6 or 8 characters");
        }
        this.checkLength(EdiConstants.DataType.DATE, minl, maxl);
        for (int i = 0; i < length; ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            this.handleError(EdiConstants.DataType.DATE, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        int day = this.tokenBuilder.charAt(length - 1) - 48 + (this.tokenBuilder.charAt(length - 2) - 48) * 10;
        int month = this.tokenBuilder.charAt(length - 3) - 48 + (this.tokenBuilder.charAt(length - 4) - 48) * 10;
        if (month == 0 || month > 12 || day == 0 || day > 31) {
            this.handleError(EdiConstants.DataType.DATE, ErrorHandler.ErrorCondition.INVALID_DATE, "month or day out of allowed range");
        }
        if (length == 8) {
            year = Integer.parseInt(this.tokenBuilder.substring(0, 4));
        } else {
            year = 2000 + (this.tokenBuilder.charAt(1) - 48) + (this.tokenBuilder.charAt(0) - 48) * 10;
            if (year > 2070) {
                year -= 100;
            }
        }
        return new GregorianCalendar(year, month - 1, day);
    }

    public int parseTime(int minl, int maxl) throws IOException {
        int second;
        int length = this.tokenBuilder.length();
        if (length != 4 && (length < 6 || length > 8)) {
            this.handleError(EdiConstants.DataType.TIME, ErrorHandler.ErrorCondition.INVALID_DATE, "time value must be either 4 or 6-8 characters");
        }
        this.checkLength(EdiConstants.DataType.TIME, minl, maxl);
        for (int i = 0; i < length; ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            this.handleError(EdiConstants.DataType.TIME, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        int hour = (this.tokenBuilder.charAt(0) - 48) * 10 + (this.tokenBuilder.charAt(1) - 48);
        int minute = (this.tokenBuilder.charAt(2) - 48) * 10 + (this.tokenBuilder.charAt(3) - 48);
        int n = second = this.tokenBuilder.length() < 6 ? 0 : (this.tokenBuilder.charAt(4) - 48) * 10 + (this.tokenBuilder.charAt(5) - 48);
        if (hour > 23 || minute > 59 || second > 59) {
            this.handleError(EdiConstants.DataType.TIME, ErrorHandler.ErrorCondition.INVALID_TIME, "time value out of allowed ranges");
        }
        int milli = 0;
        if (length > 6) {
            milli = (this.tokenBuilder.charAt(6) - 48) * 100;
            if (length > 7) {
                milli = (this.tokenBuilder.charAt(7) - 48) * 10;
            }
        }
        return ((hour * 60 + minute) * 60 + second) * 1000 + milli;
    }
}

