/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.lexical.ErrorHandler;
import com.anypoint.df.edi.lexical.LexerBase;
import com.anypoint.df.edi.lexical.LexicalDataException;
import com.anypoint.df.edi.lexical.LexicalException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;

public class FlatFileLexer
extends LexerBase {
    private final int tagWidth;

    public FlatFileLexer(InputStream is, int tag) {
        super(is);
        this.tagWidth = tag;
        this.reader = new BufferedReader(new InputStreamReader(this.stream, EdiConstants.ASCII_CHARSET));
    }

    @Override
    public void discardTo(EdiConstants.ItemType typ) throws IOException {
        if (typ != EdiConstants.ItemType.SEGMENT) {
            throw new IllegalArgumentException("Flat files do not support " + (Object)((Object)typ) + " data type positioning");
        }
        this.nextLine();
    }

    private void readToken(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int chr = this.reader.read();
            if (chr == -1) {
                throw new LexicalException("Unexpected end of file in line " + this.segmentNumber);
            }
            if (chr == 13 || chr == 10) {
                throw new LexicalException("Unexpected end of line (expected " + (length - i) + " more characters) for line " + this.segmentNumber);
            }
            this.tokenBuilder.append((char)chr);
        }
        ++this.elementNumber;
    }

    public boolean nextLine() throws IOException {
        int chr = this.reader.read();
        if (chr == -1) {
            this.currentType = EdiConstants.ItemType.END;
            return false;
        }
        if (chr != 10 && chr != 13) {
            throw new LexicalException("Missing expected line break after line " + this.segmentNumber);
        }
        while ((chr = this.reader.read()) == 10 || chr == 13) {
        }
        if (chr == -1) {
            this.currentType = EdiConstants.ItemType.END;
            return false;
        }
        this.tokenBuilder.setLength(0);
        this.tokenBuilder.append((char)chr);
        ++this.segmentNumber;
        this.elementNumber = 0;
        this.readToken(this.tagWidth - 1);
        this.segmentTag = this.tokenBuilder.toString();
        this.currentType = EdiConstants.ItemType.SEGMENT;
        return true;
    }

    public void init() throws IOException {
        this.readToken(this.tagWidth);
        this.segmentTag = this.tokenBuilder.toString();
        this.currentType = EdiConstants.ItemType.SEGMENT;
    }

    public void load(int width) throws IOException {
        this.tokenBuilder.setLength(0);
        this.readToken(width);
        this.currentType = EdiConstants.ItemType.DATA_ELEMENT;
    }

    @Override
    void handleError(EdiConstants.DataType typ, ErrorHandler.ErrorCondition err, String explain) throws LexicalException {
        boolean abort = false;
        String position = "element " + Integer.toString(this.elementNumber + 1);
        String text = err.text() + " for data type " + typ.code() + " at " + position + ": '" + this.tokenBuilder + "'";
        if (explain != null) {
            text = text + " (" + explain + ")";
        }
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ, err, text);
            }
            this.errorHandler.error(this, typ, err, explain);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                this.logger.error((Object)("Unrecoverable lexer error " + text));
            } else {
                this.logger.info((Object)("Recoverable lexer error " + text));
            }
        }
    }

    public String parseAlphaNumeric(int minl, int maxl) throws IOException {
        this.load(maxl);
        int lastns = -1;
        for (int i = 0; i < maxl; ++i) {
            if (this.tokenBuilder.charAt(i) == ' ') continue;
            lastns = i;
        }
        this.checkLength(EdiConstants.DataType.ALPHANUMERIC, lastns + 1, minl, maxl);
        return this.tokenBuilder.substring(0, lastns + 1);
    }

    @Override
    public Integer parseInteger(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseInteger(minl, maxl);
    }

    @Override
    public Object parseBigInteger(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseBigInteger(minl, maxl);
    }

    @Override
    public Object parseBigDecimal(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseBigDecimal(minl, maxl);
    }

    @Override
    public Object parseUnscaledNumber(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseUnscaledNumber(minl, maxl);
    }

    @Override
    public Calendar parseDate(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseDate(minl, maxl);
    }

    @Override
    public int parseTime(int minl, int maxl) throws IOException {
        this.load(maxl);
        return super.parseTime(minl, maxl);
    }
}

