/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.rm.store;

import java.io.IOException;
import java.io.Serializable;

import org.apache.cxf.ws.rm.persistence.RMMessage;

public class MessageTransfer implements Serializable {

  private byte[] content;
  private String contentType;
  private long messageNumber;
  private String to;
  private long createdTime;
  private boolean outbound;

  public MessageTransfer(RMMessage rmMessage, boolean outbound) throws IOException {
    this.content = rmMessage.getContent().getBytes();
    this.contentType = rmMessage.getContentType();
    this.messageNumber = rmMessage.getMessageNumber();
    this.to = rmMessage.getTo();
    this.createdTime = rmMessage.getCreatedTime();
    this.outbound = outbound;
  }

  public byte[] getContent() {
    return content;
  }

  public String getContentType() {
    return contentType;
  }

  public long getMessageNumber() {
    return messageNumber;
  }

  public String getTo() {
    return to;
  }

  public long getCreatedTime() {
    return createdTime;
  }

  public boolean isOutbound() {
    return outbound;
  }
}
