/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.client;


import org.mule.soap.api.SoapWebServiceConfiguration;
import org.mule.soap.internal.client.SoapCxfClientFactory;

/**
 * A Contract for Factory Objects that creates {@link SoapClient instances}
 *
 * @since 1.0
 */
public interface SoapClientFactory {

  /**
   * Creates a new SoapClient instance.
   *
   * @param configuration the {@link SoapWebServiceConfiguration} specifying the desired client configuration.
   * @return a newly built {@link SoapClient} based on the {@code configuration}.
   */
  SoapClient create(SoapWebServiceConfiguration configuration);

  static SoapClientFactory getDefault() {
    return Holder.INSTANCE;
  }

  final class Holder {

    static final SoapClientFactory INSTANCE = new SoapCxfClientFactory();
  }
}
