/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.message.Attachment;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.client.AbstractSoapCxfClient;
import org.mule.soap.internal.client.StreamDataSource;
import org.mule.soap.internal.generator.attachment.MtomRequestEnricher;
import org.mule.soap.internal.generator.attachment.MtomResponseEnricher;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.WsdlModel;

public class SoapMtomCxfClient
extends AbstractSoapCxfClient {
    SoapMtomCxfClient(Client client, WsdlModel wsdlModel, PortModel portModel, String address, String encoding) {
        super(client, wsdlModel, portModel, address, encoding, new MtomRequestEnricher(), new MtomResponseEnricher(portModel.getOperations()));
    }

    @Override
    protected Map<String, Attachment> buildCxfAttachments(Map<String, SoapAttachment> attachments) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        attachments.forEach((name, value) -> {
            AttachmentImpl attachment = new AttachmentImpl(name, new DataHandler((DataSource)new StreamDataSource(value.getContent(), value.getContentType(), (String)name)));
            attachment.setHeader("Content-Disposition", "attachment; name=\"" + name + "\"");
            builder.put(name, (Object)attachment);
        });
        return builder.build();
    }
}

