/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.rm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.DeferredConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionQueue;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.cxf.ws.rm.v200702.AcceptType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceType;
import org.apache.cxf.ws.rm.v200702.Expires;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.OfferType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceType;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.rm.CreateSequenceRequest;
import org.mule.soap.api.rm.TerminateSequenceRequest;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.wsdl.parser.model.operation.OperationType;

public class RMClient {
    private final RMManager manager;
    private final Client client;
    private final String address;

    public RMClient(Client client, String address) {
        this.address = address;
        this.client = client;
        this.manager = (RMManager)client.getBus().getExtension(RMManager.class);
    }

    public SourceSequence createSequence(CreateSequenceRequest request, TransportDispatcher dispatcher) throws Exception {
        AcceptType accept;
        Message message = this.getMessage();
        Source source = this.manager.getSource(message);
        RMEndpoint reliableEndpoint = source.getReliableEndpoint();
        CreateSequenceType create = new CreateSequenceType();
        create.setAcksTo(RMUtils.createAnonymousReference());
        SourcePolicyType sp = this.manager.getSourcePolicy();
        Duration d = DatatypeFactory.newInstance().newDuration(request.getSequenceTtl());
        if (d != null) {
            Expires expires = new Expires();
            expires.setValue(d);
            create.setExpires(expires);
        }
        if (sp.isIncludeOffer()) {
            OfferType offer = new OfferType();
            d = sp.getOfferedSequenceExpiration();
            if (null != d) {
                Expires expires = new Expires();
                expires.setValue(d);
                offer.setExpires(expires);
            }
            offer.setIdentifier(reliableEndpoint.getSource().generateSequenceIdentifier());
            offer.setEndpoint(RMUtils.createAnonymousReference());
            create.setOffer(offer);
        }
        ProtocolVariation protocol = ProtocolVariation.findVariant((String)request.getNamespaceUri(), (String)request.getAddressingNamespaceUri().orElse(null));
        EncoderDecoder codec = protocol.getCodec();
        OperationInfo oi = this.getOperationInfo(reliableEndpoint, protocol, codec.getConstants().getCreateSequenceOperationName());
        Object resp = this.invoke(reliableEndpoint, oi, protocol, new Object[]{codec.convertToSend(create)}, this.getInvocationContext(oi.isOneWay(), dispatcher, request.getNamespaceUri(), request.getAddressingNamespaceUri().orElse(null)), (Exchange)new ExchangeImpl());
        CreateSequenceResponseType createSequenceResponseType = codec.convertReceivedCreateSequenceResponse(resp);
        SourceSequence seq = new SourceSequence(createSequenceResponseType.getIdentifier(), protocol);
        seq.setExpires(createSequenceResponseType.getExpires());
        source.addSequence(seq);
        if (sp.isIncludeOffer() && (accept = createSequenceResponseType.getAccept()) != null) {
            Destination dest = reliableEndpoint.getDestination();
            String address = accept.getAcksTo().getAddress().getValue();
            if (!RMUtils.getAddressingConstants().getNoneURI().equals(address)) {
                DestinationSequence ds = new DestinationSequence(create.getOffer().getIdentifier(), accept.getAcksTo(), dest, protocol);
                dest.addSequence(ds);
            }
        }
        SourceSequence sourceSequence = source.getSequence(createSequenceResponseType.getIdentifier());
        sourceSequence.setTarget(RMUtils.createReference((String)this.address));
        return sourceSequence;
    }

    public void terminateSequence(TerminateSequenceRequest request, TransportDispatcher dispatcher) throws Exception {
        SourceSequence sourceSequence = this.getSourceSequence(request.getSequenceIdentifier());
        if (sourceSequence == null) {
            throw new BadRequestException(String.format("Error at sequence [%s] termination, no sequence found for that identifier.", request.getSequenceIdentifier()));
        }
        RetransmissionQueue retransmissionQueue = this.manager.getRetransmissionQueue();
        retransmissionQueue.stop(sourceSequence);
        RMEndpoint reliableEndpoint = sourceSequence.getSource().getReliableEndpoint();
        ProtocolVariation protocol = sourceSequence.getProtocol();
        RMConstants constants = protocol.getConstants();
        OperationInfo oi = this.getOperationInfo(reliableEndpoint, protocol, constants.getTerminateSequenceOperationName());
        TerminateSequenceType ts = new TerminateSequenceType();
        ts.setIdentifier(sourceSequence.getIdentifier());
        ts.setLastMsgNumber(Long.valueOf(sourceSequence.getCurrentMessageNr()));
        this.invoke(reliableEndpoint, oi, protocol, new Object[]{protocol.getCodec().convertToSend(ts)}, this.getInvocationContext(oi.isOneWay(), dispatcher), (Exchange)new ExchangeImpl());
        sourceSequence.getSource().removeSequence(sourceSequence);
    }

    private Map<String, Object> getInvocationContext(boolean isOneWay, TransportDispatcher dispatcher) {
        return this.getInvocationContext(isOneWay, dispatcher, null, null);
    }

    private Map<String, Object> getInvocationContext(boolean isOneWay, TransportDispatcher dispatcher, String namespaceUri, String addressingNamespaceUri) {
        OperationType operationType = isOneWay ? OperationType.ONE_WAY : OperationType.REQUEST_RESPONSE;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("mule.soap.attachments", Collections.emptyMap());
        props.put("mule.soap.address", this.address);
        props.put(Message.ENCODING, "UTF-8");
        props.put("mule.soap.headers", Collections.emptyList());
        props.put("mule.soap.transport.headers", Collections.emptyMap());
        props.put("mule.soap.dispatcher", dispatcher);
        props.put("mule.soap.operation.type", operationType);
        props.put("org.apache.cxf.stax.force-start-document", false);
        props.put("mule.addressing.enable", Boolean.TRUE);
        props.put("mule.reliablemessaging.enable", Boolean.TRUE);
        if (addressingNamespaceUri != null) {
            props.put(MAPAggregator.ADDRESSING_NAMESPACE, addressingNamespaceUri);
            props.put("org.apache.cxf.ws.rm.wsa-namespace", addressingNamespaceUri);
        }
        if (namespaceUri != null) {
            props.put("org.apache.cxf.ws.rm.namespace", namespaceUri);
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("RequestContext", props);
        return ctx;
    }

    private OperationInfo getOperationInfo(RMEndpoint reliableEndpoint, ProtocolVariation protocol, QName closeSequenceOperationName) {
        return reliableEndpoint.getEndpoint(protocol).getEndpointInfo().getService().getInterface().getOperation(closeSequenceOperationName);
    }

    public SourceSequence getSourceSequence(String sequence) {
        try {
            RMManager manager = (RMManager)this.client.getBus().getExtension(RMManager.class);
            Source source = manager.getSource(this.getMessage());
            Identifier identifier = new Identifier();
            identifier.setValue(sequence);
            return source.getSequence(identifier);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Message getMessage() {
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.put(Bus.class, (Object)this.client.getBus());
        exchange.put(Endpoint.class, (Object)this.client.getEndpoint());
        MessageImpl message = new MessageImpl();
        message.setExchange((Exchange)exchange);
        return message;
    }

    Object invoke(RMEndpoint reliableEndpoint, OperationInfo oi, ProtocolVariation protocol, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
        BindingOperationInfo boi;
        EndpointReferenceType replyTo;
        RMManager manager = reliableEndpoint.getManager();
        Bus bus = manager.getBus();
        Endpoint endpoint = reliableEndpoint.getEndpoint(protocol);
        Endpoint applicationEndpoint = reliableEndpoint.getApplicationEndpoint();
        BindingInfo bi = reliableEndpoint.getBindingInfo(protocol);
        Conduit c = reliableEndpoint.getConduit();
        Client innerClient = this.createClient(bus, endpoint, applicationEndpoint, protocol, c, replyTo = RMUtils.createAnonymousReference());
        Object[] result = innerClient.invoke(boi = bi.getOperation(oi), params, context, exchange);
        if (result != null && result.length > 0) {
            return result[0];
        }
        return null;
    }

    private Client createClient(Bus bus, Endpoint endpoint, Endpoint applicationEndpoint, ProtocolVariation protocol, Conduit conduit, final EndpointReferenceType address) {
        DeferredConduitSelector cs = new DeferredConduitSelector(conduit){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized Conduit selectConduit(Message message) {
                Conduit conduit = null;
                EndpointInfo endpointInfo = this.getEndpoint().getEndpointInfo();
                EndpointReferenceType original = endpointInfo.getTarget();
                try {
                    if (null != address) {
                        endpointInfo.setAddress(address);
                    }
                    conduit = super.selectConduit(message);
                }
                finally {
                    endpointInfo.setAddress(original);
                }
                return conduit;
            }
        };
        InnerClient client = new InnerClient(bus, endpoint, applicationEndpoint, (ConduitSelector)cs);
        WSAddressingFeature wsa = new WSAddressingFeature();
        wsa.setAddressingRequired(true);
        wsa.initialize((Client)client, bus);
        Map context = client.getRequestContext();
        context.put(MAPAggregator.ADDRESSING_NAMESPACE, protocol.getWSANamespace());
        context.put("org.apache.cxf.ws.rm.namespace", protocol.getWSRMNamespace());
        context.put("org.apache.cxf.ws.rm.wsa-namespace", protocol.getWSANamespace());
        return client;
    }

    class InnerClient
    extends ClientImpl {
        private final Endpoint applicationEndpoint;

        InnerClient(Bus bus, Endpoint endpoint, Endpoint applicationEndpoint, ConduitSelector cs) {
            super(bus, endpoint, cs);
            this.applicationEndpoint = applicationEndpoint;
        }

        public void onMessage(Message m) {
            m.getExchange().put(Endpoint.class, (Object)this.applicationEndpoint);
            super.onMessage(m);
        }
    }
}

