/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.security.configuration;

import java.util.List;
import java.util.Properties;
import org.mule.soap.api.security.configuration.WssPart;

public class WssEncryptionConfiguration {
    private String encryptionKeyIdentifier;
    private String encryptionSymAlgorithm;
    private String encryptionKeyTransportAlgorithm;
    private String encryptionDigestAlgorithm;
    private List<WssPart> wssParts;

    public WssEncryptionConfiguration(String encryptionKeyIdentifier, String encryptionSymAlgorithm, String encryptionKeyTransportAlgorithm, String encryptionDigestAlgorithm, List<WssPart> wssParts) {
        this.encryptionKeyIdentifier = encryptionKeyIdentifier;
        this.encryptionSymAlgorithm = encryptionSymAlgorithm;
        this.encryptionKeyTransportAlgorithm = encryptionKeyTransportAlgorithm;
        this.encryptionDigestAlgorithm = encryptionDigestAlgorithm;
        this.wssParts = wssParts;
    }

    public String getEncryptionKeyIdentifier() {
        return this.encryptionKeyIdentifier;
    }

    public String getEncryptionSymAlgorithm() {
        return this.encryptionSymAlgorithm;
    }

    public String getEncryptionKeyTransportAlgorithm() {
        return this.encryptionKeyTransportAlgorithm;
    }

    public String getEncryptionDigestAlgorithm() {
        return this.encryptionDigestAlgorithm;
    }

    public List<WssPart> getWssParts() {
        return this.wssParts;
    }

    public Properties getConfigurationProperties() {
        Properties properties = new Properties();
        if (this.encryptionKeyIdentifier != null) {
            properties.setProperty("encryptionKeyIdentifier", this.encryptionKeyIdentifier);
        }
        if (this.encryptionSymAlgorithm != null) {
            properties.setProperty("encryptionSymAlgorithm", this.encryptionSymAlgorithm);
        }
        if (this.encryptionKeyTransportAlgorithm != null) {
            if (this.encryptionKeyTransportAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                properties.setProperty("allowRSA15KeyTransportAlgorithm", "true");
            }
            properties.setProperty("encryptionKeyTransportAlgorithm", this.encryptionKeyTransportAlgorithm);
        }
        if (this.encryptionDigestAlgorithm != null) {
            properties.setProperty("encryptionDigestAlgorithm", this.encryptionDigestAlgorithm);
        }
        if (this.wssParts != null) {
            StringBuilder sb = new StringBuilder();
            for (WssPart wssPart : this.wssParts) {
                sb.append(wssPart.toString());
            }
            properties.setProperty("encryptionParts", sb.toString());
        }
        return properties;
    }
}

