/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.util.List;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.extension.http.api.request.builder.QueryParam;
import org.mule.extension.http.api.request.builder.RequestHeader;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;

public final class RequestSettings {
    @Parameter
    @Optional(defaultValue="true")
    private boolean followRedirects;
    @Parameter
    @Optional(defaultValue="AUTO")
    private HttpSendBodyMode sendBodyMode;
    @Parameter
    @Optional(defaultValue="AUTO")
    @Summary(value="Defines if the request should be sent using streaming or not. If this attribute is not present, the behavior will depend on the type of the payload (it will stream only for InputStream).")
    private HttpStreamingType requestStreamingMode;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean enableCookies;
    @Parameter
    @Optional
    @NullSafe
    private List<RequestHeader> defaultHeaders;
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="Query Parameters")
    private List<QueryParam> defaultQueryParams;
    @Parameter
    @Optional(defaultValue="AUTO")
    private OutboundCorrelationStrategy sendCorrelationId = OutboundCorrelationStrategy.AUTO;
    @Parameter
    @Optional(defaultValue="false")
    private boolean preserveHeadersCase = false;

    public List<RequestHeader> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public List<QueryParam> getDefaultQueryParams() {
        return this.defaultQueryParams;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public HttpSendBodyMode getSendBodyMode() {
        return this.sendBodyMode;
    }

    public HttpStreamingType getRequestStreamingMode() {
        return this.requestStreamingMode;
    }

    public boolean isEnableCookies() {
        return this.enableCookies;
    }

    public OutboundCorrelationStrategy getSendCorrelationId() {
        return this.sendCorrelationId;
    }

    public boolean isPreserveHeadersCase() {
        return this.preserveHeadersCase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean followRedirects;
        private HttpSendBodyMode sendBodyMode;
        private HttpStreamingType requestStreamingMode;
        private boolean enableCookies;
        private List<RequestHeader> defaultHeaders;
        private List<QueryParam> defaultQueryParams;
        private OutboundCorrelationStrategy sendCorrelationId = OutboundCorrelationStrategy.AUTO;
        private boolean preserveHeadersCase = false;

        public Builder withFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder withHttpSendBodyMode(HttpSendBodyMode sendBodyMode) {
            this.sendBodyMode = sendBodyMode;
            return this;
        }

        public Builder withHttpStreamingType(HttpStreamingType requestStreamingMode) {
            this.requestStreamingMode = requestStreamingMode;
            return this;
        }

        public Builder withEnableCookies(boolean enableCookies) {
            this.enableCookies = enableCookies;
            return this;
        }

        public Builder withDefaultHeaders(List<RequestHeader> defaultHeaders) {
            this.defaultHeaders = defaultHeaders;
            return this;
        }

        public Builder withDefaultQueryParams(List<QueryParam> defaultQueryParams) {
            this.defaultQueryParams = defaultQueryParams;
            return this;
        }

        public Builder withOutboundCorrelationStrategy(OutboundCorrelationStrategy sendCorrelationId) {
            this.sendCorrelationId = sendCorrelationId;
            return this;
        }

        public Builder withPreserveHeadersCase(boolean preserveHeadersCase) {
            this.preserveHeadersCase = preserveHeadersCase;
            return this;
        }

        public RequestSettings build() {
            RequestSettings settings = new RequestSettings();
            settings.followRedirects = this.followRedirects;
            settings.sendBodyMode = this.sendBodyMode;
            settings.requestStreamingMode = this.requestStreamingMode;
            settings.enableCookies = this.enableCookies;
            settings.defaultHeaders = this.defaultHeaders;
            settings.defaultQueryParams = this.defaultQueryParams;
            settings.sendCorrelationId = this.sendCorrelationId;
            settings.preserveHeadersCase = this.preserveHeadersCase;
            return settings;
        }
    }
}

