/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.util.Objects;
import org.mule.extension.socket.api.socket.tcp.TcpClientSocketProperties;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpConstants;

public final class RequestConnectionParams {
    public static final String DEFAULT_MAX_CONNECTIONS = "-1";
    public static final String DEFAULT_CONNECTION_IDLE_TIMEOUT = "30000";
    public static final String DEFAULT_RESPONSE_BUFFER_SIZE = "-1";
    @Parameter
    @Optional(defaultValue="HTTP")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Protocol to use for communication. Valid values are HTTP and HTTPS")
    @Placement(order=1)
    private HttpConstants.Protocol protocol;
    @Parameter
    @Optional
    @Example(value="www.mulesoft.com")
    @Placement(order=2)
    private String host;
    @Parameter
    @Optional
    @Placement(order=3)
    private Integer port;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=1)
    private boolean usePersistentConnections;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=2)
    private Integer maxConnections;
    @Parameter
    @Optional(defaultValue="30000")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=3)
    private Integer connectionIdleTimeout;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=4)
    private boolean streamResponse;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=5)
    private int responseBufferSize;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=6)
    private TcpClientSocketProperties clientSocketProperties;

    public HttpConstants.Protocol getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public boolean getUsePersistentConnections() {
        return this.usePersistentConnections;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Integer getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public boolean getStreamResponse() {
        return this.streamResponse;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public TcpClientSocketProperties getClientSocketProperties() {
        return this.clientSocketProperties;
    }

    public void setProtocol(HttpConstants.Protocol protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUsePersistentConnections(boolean usePersistentConnections) {
        this.usePersistentConnections = usePersistentConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setConnectionIdleTimeout(Integer connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public void setStreamResponse(boolean streamResponse) {
        this.streamResponse = streamResponse;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public void setClientSocketProperties(TcpClientSocketProperties clientSocketProperties) {
        this.clientSocketProperties = clientSocketProperties;
    }

    public int hashCode() {
        return Objects.hash(this.clientSocketProperties, this.connectionIdleTimeout, this.host, this.maxConnections, this.port, this.protocol, this.responseBufferSize, this.streamResponse, this.usePersistentConnections);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestConnectionParams other = (RequestConnectionParams)obj;
        return Objects.equals(this.clientSocketProperties, other.clientSocketProperties) && Objects.equals(this.connectionIdleTimeout, other.connectionIdleTimeout) && Objects.equals(this.host, other.host) && Objects.equals(this.maxConnections, other.maxConnections) && Objects.equals(this.port, other.port) && this.protocol == other.protocol && this.responseBufferSize == other.responseBufferSize && this.streamResponse == other.streamResponse && this.usePersistentConnections == other.usePersistentConnections;
    }
}

