/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.net.CookieManager;
import java.util.List;
import javax.inject.Inject;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.extension.http.api.request.builder.QueryParam;
import org.mule.extension.http.api.request.builder.RequestHeader;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.request.HttpPollingSource;
import org.mule.extension.http.internal.request.HttpRequestOperations;
import org.mule.extension.http.internal.request.HttpRequesterCookieConfig;
import org.mule.extension.http.internal.request.HttpRequesterProvider;
import org.mule.extension.http.internal.request.RequestSettings;
import org.mule.extension.http.internal.request.RequestUrlConfiguration;
import org.mule.extension.http.internal.request.ResponseSettings;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Configuration(name="requestConfig")
@ConnectionProviders(value={HttpRequesterProvider.class})
@Operations(value={HttpRequestOperations.class})
@Sources(value={HttpPollingSource.class})
public class HttpRequesterConfig
implements Initialisable,
HttpRequesterCookieConfig {
    @ParameterGroup(name="URL Configuration")
    @Placement(order=1)
    private RequestUrlConfiguration urlConfiguration;
    @ParameterGroup(name="Request Settings")
    @Placement(order=2)
    private RequestSettings requestSettings;
    @ParameterGroup(name="Response Settings")
    @Placement(order=3)
    private ResponseSettings responseSettings;
    @Inject
    private MuleContext muleContext;
    private CookieManager cookieManager;

    public void initialise() throws InitialisationException {
        if (this.requestSettings.isEnableCookies()) {
            this.cookieManager = new CookieManager();
        }
    }

    public String getBasePath() {
        return this.urlConfiguration.getBasePath();
    }

    public List<RequestHeader> getDefaultHeaders() {
        return this.requestSettings.getDefaultHeaders();
    }

    public List<QueryParam> getDefaultQueryParams() {
        return this.requestSettings.getDefaultQueryParams();
    }

    public boolean getFollowRedirects() {
        return this.requestSettings.getFollowRedirects();
    }

    public HttpStreamingType getRequestStreamingMode() {
        return this.requestSettings.getRequestStreamingMode();
    }

    public HttpSendBodyMode getSendBodyMode() {
        return this.requestSettings.getSendBodyMode();
    }

    public boolean isPreserveHeadersCase() {
        return this.requestSettings.isPreserveHeadersCase();
    }

    public Integer getResponseTimeout() {
        return this.responseSettings.getResponseTimeout();
    }

    @Override
    public boolean isEnableCookies() {
        return this.requestSettings.isEnableCookies();
    }

    @Override
    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private RequestUrlConfiguration urlConfiguration;
        private RequestSettings requestSettings;
        private ResponseSettings responseSettings;
        private MuleContext muleContext;

        private Builder() {
        }

        public Builder withUrlConfiguration(RequestUrlConfiguration urlConfiguration) {
            this.urlConfiguration = urlConfiguration;
            return this;
        }

        public Builder withRequestSettings(RequestSettings requestSettings) {
            this.requestSettings = requestSettings;
            return this;
        }

        public Builder withResponseSettings(ResponseSettings responseSettings) {
            this.responseSettings = responseSettings;
            return this;
        }

        public Builder withMuleContext(MuleContext muleContext) {
            this.muleContext = muleContext;
            return this;
        }

        public HttpRequesterConfig build() {
            if (this.muleContext == null) {
                throw new IllegalStateException("muleContext must be set");
            }
            HttpRequesterConfig config = new HttpRequesterConfig();
            config.urlConfiguration = this.urlConfiguration;
            config.requestSettings = this.requestSettings;
            config.responseSettings = this.responseSettings;
            config.muleContext = this.muleContext;
            return config;
        }
    }
}

