/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.request.builder.HttpRequesterSimpleRequestBuilder;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.response.HttpPollingSourceExpressions;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.request.validator.SuccessStatusCodeValidator;
import org.mule.extension.http.internal.HttpMetadataResolver;
import org.mule.extension.http.internal.request.CorrelationData;
import org.mule.extension.http.internal.request.EmptyDistributedTraceContextManager;
import org.mule.extension.http.internal.request.HttpPollingSourceUtils;
import org.mule.extension.http.internal.request.HttpRequestUtils;
import org.mule.extension.http.internal.request.HttpRequester;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.RequestCreator;
import org.mule.extension.http.internal.request.UriUtils;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="pollingSource")
@MediaType(value="*/*", strict=false)
@MetadataScope(outputResolver=HttpMetadataResolver.class)
@Streaming
@BackPressure(defaultMode=BackPressureMode.WAIT, supportedModes={BackPressureMode.DROP, BackPressureMode.WAIT, BackPressureMode.FAIL})
public class HttpPollingSource
extends PollingSource<String, HttpResponseAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpPollingSource.class);
    public static final String PAYLOAD_PLACEHOLDER = "payload";
    public static final String ITEM_PLACEHOLDER = "item";
    public static final String ATTRIBUTES_PLACEHOLDER = "attributes";
    public static final String WATERMARK_PLACEHOLDER = "watermark";
    @Connection
    private ConnectionProvider<HttpExtensionClient> clientProvider;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private TransformationService transformationService;
    @Inject
    @Named(value="http.request.fixedHeadersRegistry")
    private HashMap<String, List<String>> injectedHeaders;
    @Config
    private HttpRequesterConfig config;
    @Inject
    private MuleContext muleContext;
    @Inject
    private ExpressionLanguage expressionLanguage;
    private HttpExtensionClient client;
    private Scheduler scheduler;
    private HttpRequester httpRequester;
    private ComponentLocation location;
    @Parameter
    @Placement(order=1)
    @org.mule.runtime.extension.api.annotation.param.Optional
    private String path = "";
    @Parameter
    @Placement(order=2)
    @Example(value="GET")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="GET")
    private String method;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @DisplayName(value="Response Validator")
    @Placement(order=3)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ResponseValidator responseValidator;
    @ParameterGroup(name="Request")
    @Placement(order=4)
    private HttpRequesterSimpleRequestBuilder requestBuilder;
    @ParameterGroup(name="Expressions")
    @Placement(order=5)
    private HttpPollingSourceExpressions expressions;
    private SuccessStatusCodeValidator defaultStatusCodeValidator = new SuccessStatusCodeValidator("0..399");

    private ResponseValidator getResponseValidator() {
        return this.responseValidator != null ? this.responseValidator : this.defaultStatusCodeValidator;
    }

    private void validateExpression(String exp) {
        ValidationResult validation = HttpPollingSourceUtils.isValidExpression(exp, this.expressionLanguage);
        if (!validation.isSuccess()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid expression '%s' at HTTP Polling Source at %s - %s", exp, this.location.getRootContainerName(), validation.errorMessage().orElse(""))));
        }
    }

    private void validateExpressions() {
        this.validateExpression(this.requestBuilder.getPollingRequestBody());
        this.requestBuilder.getRequestHeaders().forEach(header -> this.validateExpression(header.getValue()));
        this.requestBuilder.getRequestQueryParams().forEach(queryParam -> this.validateExpression(queryParam.getValue()));
    }

    protected void doStart() throws MuleException {
        LOGGER.debug("Starting HTTP Polling Source in {}", (Object)this.location.getRootContainerName());
        this.scheduler = this.schedulerService.ioScheduler();
        this.client = (HttpExtensionClient)this.clientProvider.connect();
        this.httpRequester = HttpRequestUtils.createHttpRequester(false, this.muleContext);
        this.validateExpressions();
    }

    protected void doStop() {
        LOGGER.debug("Stopping HTTP Polling Source in {}", (Object)this.location.getRootContainerName());
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    private String getResolvedUri(Serializable watermark) {
        UriParameters uriParameters = this.client.getDefaultUriParameters();
        String resolvedPath = UriUtils.replaceUriParams(UriUtils.buildPath(this.config.getBasePath(), this.path), HttpPollingSourceUtils.resolveUriParams(this.requestBuilder.getRequestUriParams(), watermark, this.expressionLanguage));
        return UriUtils.resolveUri(uriParameters.getScheme(), uriParameters.getHost().trim(), uriParameters.getPort(), resolvedPath);
    }

    private Consumer<PollContext.PollItem<String, HttpResponseAttributes>> getPollingItemConsumer(TypedValue<String> fullResponse, Result<TypedValue<?>, HttpResponseAttributes> item, Serializable watermark) {
        return pollItem -> {
            LOGGER.debug("Setting Result for {}: {} with attributes {}", new Object[]{this.location.getRootContainerName(), item.getOutput(), item.getAttributes().orElse(null)});
            pollItem.setResult(HttpPollingSource.toStringResult(item));
            this.expressions.getIdExpression().ifPresent(idExp -> pollItem.setId(HttpPollingSourceUtils.getItemId(fullResponse, idExp, watermark, item, this.expressionLanguage)));
            this.expressions.getWatermarkExpression().ifPresent(wExp -> pollItem.setWatermark(HttpPollingSourceUtils.getItemWatermark(fullResponse, wExp, watermark, item, this.expressionLanguage)));
        };
    }

    private void pollResult(PollContext<String, HttpResponseAttributes> pollContext, Result<InputStream, HttpResponseAttributes> result, Serializable currentWatermark, String resolvedUri) {
        HttpResponseAttributes attributes = result.getAttributes().orElse(null);
        org.mule.runtime.api.metadata.MediaType mediaType = result.getMediaType().orElse(org.mule.runtime.api.metadata.MediaType.ANY);
        Charset charset = mediaType.getCharset().orElse(Charset.defaultCharset());
        TypedValue<String> response = HttpPollingSource.toTypedValue(IOUtils.toString((InputStream)((InputStream)result.getOutput()), (Charset)charset), mediaType, charset);
        LOGGER.debug("Received response at {}: {} and headers {}", new Object[]{this.location.getRootContainerName(), response, attributes.getHeaders()});
        Reference atLeastOneResult = new Reference((Object)false);
        HttpPollingSourceUtils.getItems(response, attributes, currentWatermark, this.expressions.getSplitExpression(), this.expressionLanguage).forEach(item -> {
            atLeastOneResult.set((Object)true);
            pollContext.accept(this.getPollingItemConsumer(response, (Result<TypedValue<?>, HttpResponseAttributes>)item, currentWatermark));
        });
        if (!((Boolean)atLeastOneResult.get()).booleanValue()) {
            LOGGER.debug("Empty result in HTTP Polling Source at {} of uri {}", (Object)this.location.getRootContainerName(), (Object)resolvedUri);
        }
    }

    private RequestCreator getRequesCreator(final Serializable watermark) {
        return new RequestCreator(){

            @Override
            public HttpRequestBuilder createRequestBuilder(HttpRequesterConfig config) {
                return ((HttpRequestBuilder)HttpPollingSource.this.requestBuilder.toHttpRequestBuilder(config).headers(HttpPollingSourceUtils.resolveHeaders(HttpPollingSource.this.requestBuilder.getRequestHeaders(), watermark, HttpPollingSource.this.expressionLanguage))).queryParams(HttpPollingSourceUtils.resolveQueryParams(HttpPollingSource.this.requestBuilder.getRequestQueryParams(), watermark, HttpPollingSource.this.expressionLanguage));
            }

            @Override
            public TypedValue<?> getBody() {
                return HttpPollingSourceUtils.resolveBody(HttpPollingSource.this.requestBuilder.getPollingRequestBody(), watermark, HttpPollingSource.this.expressionLanguage);
            }

            @Override
            public Optional<CorrelationData> getCorrelationData() {
                return Optional.empty();
            }
        };
    }

    private void sendRequest(PollContext<String, HttpResponseAttributes> pollContext) {
        Serializable currentWatermark = pollContext.getWatermark().orElse(null);
        String resolvedUri = this.getResolvedUri(currentWatermark);
        LOGGER.debug("Sending '{}' request to '{}' in flow '{}'.", new Object[]{this.method, resolvedUri, this.location.getRootContainerName()});
        try {
            Result<InputStream, HttpResponseAttributes> result = this.httpRequester.doSyncRequest(this.client, this.config, resolvedUri, this.method, this.config.getRequestStreamingMode(), this.config.getSendBodyMode(), this.config.getFollowRedirects(), this.client.getDefaultAuthentication(), this.config.getResponseTimeout(), this.getResponseValidator(), this.transformationService, this.getRequesCreator(currentWatermark), true, this.muleContext, this.scheduler, this.injectedHeaders, EmptyDistributedTraceContextManager.getDistributedTraceContextManager());
            this.pollResult(pollContext, result, currentWatermark, resolvedUri);
        }
        catch (ExecutionException e) {
            LOGGER.error("There was an error in HTTP Polling Source at {} of uri '{}'", new Object[]{this.location.getRootContainerName(), resolvedUri, e});
        }
        catch (InterruptedException e) {
            LOGGER.error("There was an error in HTTP Polling Source at {} of uri '{}'", new Object[]{this.location.getRootContainerName(), resolvedUri, e});
            Thread.currentThread().interrupt();
        }
    }

    public void poll(PollContext<String, HttpResponseAttributes> pollContext) {
        if (pollContext.isSourceStopping()) {
            return;
        }
        this.sendRequest(pollContext);
    }

    public void onRejectedItem(Result<String, HttpResponseAttributes> result, SourceCallbackContext sourceCallbackContext) {
        LOGGER.debug("Item rejected by HTTP Polling Source in flow '{}', result: '{}'", (Object)this.location.getRootContainerName(), result.getOutput());
    }

    private static Result<String, HttpResponseAttributes> toStringResult(Result<TypedValue<?>, HttpResponseAttributes> org) {
        return Result.builder().attributes(org.getAttributes().get()).output((Object)((TypedValue)org.getOutput()).getValue().toString()).mediaType((org.mule.runtime.api.metadata.MediaType)org.getMediaType().get()).build();
    }

    private static TypedValue<String> toTypedValue(String value, org.mule.runtime.api.metadata.MediaType mediaType, Charset encoding) {
        if (mediaType.matches(org.mule.runtime.api.metadata.MediaType.TEXT)) {
            return TypedValue.of((Object)value);
        }
        return new TypedValue((Object)value, DataType.builder().mediaType(mediaType).charset(encoding).build());
    }
}

