/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.request.validator;

import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.request.validator.ResponseValidatorTypedException;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

@TypeDsl(allowTopLevelDefinition=true)
public class ExpressionResponseValidator
implements ResponseValidator {
    @Parameter
    private Literal<String> expression;
    @Inject
    private ExpressionManager expressionManager;

    @Override
    public void validate(Result<InputStream, HttpResponseAttributes> result, HttpRequest request) {
        Optional optExpression = this.expression.getLiteralValue();
        if (!optExpression.isPresent()) {
            throw new IllegalStateException("The expression literal value hasn't been provided");
        }
        BindingContext bindingContext = ExpressionResponseValidator.buildBindingContext(result);
        TypedValue validationResult = this.expressionManager.evaluate((String)optExpression.get(), bindingContext);
        if (!DataType.BOOLEAN.isCompatibleWith(validationResult.getDataType())) {
            throw new ResponseValidatorTypedException(String.format("The expression '%s' returned a non boolean value", optExpression.get()), HttpError.BAD_REQUEST);
        }
        if (!((Boolean)validationResult.getValue()).booleanValue()) {
            throw new ResponseValidatorTypedException(String.format("The expression '%s' evaluated to false", optExpression.get()), HttpError.BAD_REQUEST);
        }
    }

    private static BindingContext buildBindingContext(Result<? extends InputStream, ? extends HttpResponseAttributes> result) {
        InputStream payload = (InputStream)result.getOutput();
        HttpResponseAttributes attributes = result.getAttributes().orElse(null);
        MediaType mediaType = result.getMediaType().orElse(MediaType.ANY);
        return BindingContext.builder().addBinding("payload", new TypedValue((Object)payload, DataType.fromType(InputStream.class))).addBinding("attributes", new TypedValue((Object)attributes, DataType.fromType(HttpResponseAttributes.class))).addBinding("mediaType", new TypedValue((Object)mediaType, DataType.fromType(MediaType.class))).build();
    }

    public Literal<String> getExpression() {
        return this.expression;
    }

    @Override
    public boolean mayConsumeBody() {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExpressionResponseValidator)) {
            return false;
        }
        ExpressionResponseValidator otherValidator = (ExpressionResponseValidator)other;
        return Objects.equals(this.expression, otherValidator.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }
}

