/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.request.builder;

import java.util.Collections;
import java.util.List;
import org.mule.extension.http.api.request.builder.SimpleQueryParam;
import org.mule.extension.http.api.request.builder.SimpleRequestHeader;
import org.mule.extension.http.api.request.builder.SimpleUriParam;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.server.HttpServerProperties;

public class HttpRequesterSimpleRequestBuilder {
    @Parameter
    @Optional(defaultValue="")
    @Text
    @DisplayName(value="Body")
    private Literal<String> pollingRequestBody;
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="Headers")
    protected List<SimpleRequestHeader> pollingRequestHeaders = Collections.emptyList();
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="URI Parameters")
    private List<SimpleUriParam> pollingRequestUriParams = Collections.emptyList();
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="Query Parameters")
    private List<SimpleQueryParam> pollingRequestQueryParams = Collections.emptyList();

    public String getPollingRequestBody() {
        return this.pollingRequestBody.getLiteralValue().orElse("");
    }

    public List<SimpleRequestHeader> getRequestHeaders() {
        return Collections.unmodifiableList(this.pollingRequestHeaders);
    }

    public List<SimpleQueryParam> getRequestQueryParams() {
        return Collections.unmodifiableList(this.pollingRequestQueryParams);
    }

    public List<SimpleUriParam> getRequestUriParams() {
        return Collections.unmodifiableList(this.pollingRequestUriParams);
    }

    public HttpRequestBuilder toHttpRequestBuilder(HttpRequesterConfig config) {
        return HttpRequest.builder((HttpServerProperties.PRESERVE_HEADER_CASE || config.isPreserveHeadersCase() ? 1 : 0) != 0);
    }
}

