/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.error;

import java.util.Optional;
import org.mule.extension.http.api.error.HttpError;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public class HttpErrorMessageGenerator {
    public String createFrom(HttpRequest request, String message) {
        return this.getBaseMessage(request).append(": ").append(message).append(".").toString();
    }

    public String createFrom(HttpRequest request, int statusCode) {
        StringBuilder stringBuilder = this.getBaseMessage(request);
        Optional<HttpError> httpError = HttpError.getErrorByCode(statusCode);
        stringBuilder.append(httpError.map(error -> ": " + error.getErrorMessage(request) + " (" + statusCode + ")").orElse(" with status code " + statusCode)).append(".");
        return stringBuilder.toString();
    }

    private StringBuilder getBaseMessage(HttpRequest request) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HTTP ").append(request.getMethod()).append(" on resource '").append(request.getUri()).append("' failed");
        return stringBuilder;
    }
}

