/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.mule.extension.http.api.BaseHttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.extension.http.api.certificate.CertificateData;
import org.mule.extension.http.internal.certificate.CertificateProvider;
import org.mule.extension.http.internal.certificate.CertificateProviderFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class HttpRequestAttributes
extends BaseHttpRequestAttributes {
    private static final long serialVersionUID = 7227330842640270811L;
    @Parameter
    private final String listenerPath;
    @Parameter
    protected String rawRequestPath;
    @Parameter
    private final String relativePath;
    @Parameter
    private final String maskedRequestPath;
    @Parameter
    private final String version;
    @Parameter
    private final String scheme;
    @Parameter
    private final String method;
    @Parameter
    private final String requestUri;
    @Parameter
    private final String rawRequestUri;
    @Parameter
    private final String queryString;
    @Parameter
    private final String localAddress;
    @Parameter
    private final String remoteAddress;
    @Parameter
    @Optional
    private CertificateData clientCertificate;
    private final CertificateProvider lazyClientCertificateProvider;

    public static HttpRequestAttributesBuilder builder() {
        return new HttpRequestAttributesBuilder();
    }

    @Deprecated
    public HttpRequestAttributes(MultiMap<String, String> headers, String listenerPath, String relativePath, String version, String scheme, String method, String requestPath, String requestUri, String queryString, MultiMap<String, String> queryParams, Map<String, String> uriParams, String remoteAddress, CertificateData clientCertificate) {
        this(headers, listenerPath, relativePath, null, version, scheme, method, requestPath, "", requestUri, "", queryString, queryParams, uriParams, "", remoteAddress, () -> clientCertificate);
    }

    HttpRequestAttributes(MultiMap<String, String> headers, String listenerPath, String relativePath, String maskedRequestPath, String version, String scheme, String method, String requestPath, String rawRequestPath, String requestUri, String rawRequestUri, String queryString, MultiMap<String, String> queryParams, Map<String, String> uriParams, String localAddress, String remoteAddress, Supplier<CertificateData> certificateSupplier) {
        super(headers, queryParams, uriParams, requestPath);
        this.listenerPath = listenerPath;
        this.rawRequestPath = rawRequestPath;
        this.relativePath = relativePath;
        this.maskedRequestPath = maskedRequestPath;
        this.version = version;
        this.scheme = scheme;
        this.method = method;
        this.requestUri = requestUri;
        this.rawRequestUri = rawRequestUri;
        this.queryString = queryString;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.lazyClientCertificateProvider = CertificateProviderFactory.create(certificateSupplier);
    }

    public String getListenerPath() {
        return this.listenerPath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getRawRequestPath() {
        return this.rawRequestPath;
    }

    public String getMaskedRequestPath() {
        return this.maskedRequestPath;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getRawRequestUri() {
        return this.rawRequestUri;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public CertificateData getClientCertificate() {
        this.clientCertificate = this.lazyClientCertificateProvider.getCertificate();
        return this.clientCertificate;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append(System.lineSeparator()).append("{").append(System.lineSeparator()).append("   ").append("Request path=").append(this.requestPath).append(System.lineSeparator()).append("   ").append("Raw request path=").append(this.rawRequestPath).append(System.lineSeparator()).append("   ").append("Method=").append(this.method).append(System.lineSeparator()).append("   ").append("Listener path=").append(this.listenerPath).append(System.lineSeparator()).append("   ").append("Local Address=").append(this.localAddress).append(System.lineSeparator()).append("   ").append("Query String=").append(this.obfuscateQueryIfNecessary()).append(System.lineSeparator()).append("   ").append("Relative Path=").append(this.relativePath).append(System.lineSeparator()).append("   ").append("Masked Request Path=").append(this.maskedRequestPath).append(System.lineSeparator()).append("   ").append("Remote Address=").append(this.remoteAddress).append(System.lineSeparator()).append("   ").append("Request Uri=").append(this.requestUri).append(System.lineSeparator()).append("   ").append("Raw request Uri=").append(this.rawRequestUri).append(System.lineSeparator()).append("   ").append("Scheme=").append(this.scheme).append(System.lineSeparator()).append("   ").append("Version=").append(this.version).append(System.lineSeparator());
        HttpRequestAttributes.buildMapToString((Map)this.headers, "Headers", this.headers.entryList().stream(), builder);
        HttpRequestAttributes.buildMapToString((Map)this.queryParams, "Query Parameters", this.queryParams.entryList().stream(), builder);
        HttpRequestAttributes.buildMapToString(this.uriParams, "URI Parameters", this.uriParams.entrySet().stream(), builder);
        builder.append("}");
        return builder.toString();
    }

    private String obfuscateQueryIfNecessary() {
        if (this.queryParams.keySet().stream().anyMatch(key -> key.equals("pass") || key.equals("password") || key.contains("secret"))) {
            return "****";
        }
        return this.queryString;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.clientCertificate, this.listenerPath, this.localAddress, this.maskedRequestPath, this.method, this.queryString, this.rawRequestPath, this.rawRequestUri, this.relativePath, this.remoteAddress, this.requestUri, this.scheme, this.version);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpRequestAttributes other = (HttpRequestAttributes)obj;
        return Objects.equals(this.clientCertificate, other.clientCertificate) && Objects.equals(this.listenerPath, other.listenerPath) && Objects.equals(this.localAddress, other.localAddress) && Objects.equals(this.maskedRequestPath, other.maskedRequestPath) && Objects.equals(this.method, other.method) && Objects.equals(this.queryString, other.queryString) && Objects.equals(this.rawRequestPath, other.rawRequestPath) && Objects.equals(this.rawRequestUri, other.rawRequestUri) && Objects.equals(this.relativePath, other.relativePath) && Objects.equals(this.remoteAddress, other.remoteAddress) && Objects.equals(this.requestUri, other.requestUri) && Objects.equals(this.scheme, other.scheme) && Objects.equals(this.version, other.version);
    }
}

