/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public abstract class HttpAttributes
implements Serializable {
    private static final long serialVersionUID = -5172640902396741873L;
    public static final String TAB = "   ";
    public static final String DOUBLE_TAB = "      ";
    @Parameter
    protected MultiMap<String, String> headers;

    public HttpAttributes(MultiMap<String, String> headers) {
        this.headers = headers.toImmutableMultiMap();
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static String formatHttpAttributesMapsToString(String name, Stream<Map.Entry<String, String>> stream) {
        StringBuilder builder = new StringBuilder();
        builder.append(TAB).append(name).append("=[").append(System.lineSeparator());
        stream.forEach(element -> builder.append(DOUBLE_TAB).append((String)element.getKey()).append("=").append(HttpAttributes.obfuscateValueIfNecessary(element)).append(System.lineSeparator()));
        builder.append(TAB).append("]").append(System.lineSeparator());
        return builder.toString();
    }

    private static String obfuscateValueIfNecessary(Map.Entry<String, String> entry) {
        String key = entry.getKey();
        if (key.equals("password") || key.equals("pass") || key.contains("secret") || key.contains("authorization")) {
            return "****";
        }
        return entry.getValue();
    }

    public static StringBuilder buildMapToString(Map map, String name, Stream stream, StringBuilder builder) {
        if (map.isEmpty()) {
            builder.append(TAB).append(name).append("=[]").append(System.lineSeparator());
            return builder;
        }
        builder.append(HttpAttributes.formatHttpAttributesMapsToString(name, stream));
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.headers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpAttributes other = (HttpAttributes)obj;
        return Objects.equals(this.headers, other.headers);
    }
}

