/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request.profiling.tracing;

import java.net.URI;
import org.mule.extension.http.internal.request.profiling.tracing.HttpCurrentSpanCustomizer;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestCurrentSpanCustomizer
extends HttpCurrentSpanCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestCurrentSpanCustomizer.class);
    public static final String HTTP_URL = "http.url";
    public static final String NET_PEER_PORT = "net.peer.port";
    public static final String NET_PEER_NAME = "net.peer.name";
    private static final String SPAN_KIND_NAME = "CLIENT";
    public static final String PROTOCOL_VERSION_0_9 = "0.9";
    public static final String PROTOCOL_VERSION_1_0 = "1.0";
    public static final String PROTOCOL_VERSION_1_1 = "1.1";
    private HttpRequest httpRequest;

    public static HttpCurrentSpanCustomizer getHttpRequesterCurrentSpanCustomizer(HttpRequest httpRequest) {
        return new HttpRequestCurrentSpanCustomizer(httpRequest);
    }

    private HttpRequestCurrentSpanCustomizer(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    @Override
    public void customizeSpan(DistributedTraceContextManager distributedTraceContextManager) {
        super.customizeSpan(distributedTraceContextManager);
        try {
            distributedTraceContextManager.addCurrentSpanAttribute(HTTP_URL, this.getURI().toString());
            if (this.getURI().getPort() == -1) {
                distributedTraceContextManager.addCurrentSpanAttribute(NET_PEER_PORT, String.valueOf(this.getURI().toURL().getDefaultPort()));
            } else {
                distributedTraceContextManager.addCurrentSpanAttribute(NET_PEER_PORT, String.valueOf(this.getURI().getPort()));
            }
            distributedTraceContextManager.addCurrentSpanAttribute(NET_PEER_NAME, this.getURI().getHost());
        }
        catch (Throwable e) {
            LOGGER.warn("Error on setting the request span attributes", e);
        }
    }

    @Override
    public String getProtocol() {
        return this.httpRequest.getUri().getScheme().toUpperCase();
    }

    @Override
    public String getMethod() {
        return this.httpRequest.getMethod().toUpperCase();
    }

    @Override
    public String getFlavor() {
        return HttpRequestCurrentSpanCustomizer.getHttpProtocolVersionFrom(this.httpRequest.getProtocol());
    }

    @Override
    public URI getURI() {
        return this.httpRequest.getUri();
    }

    @Override
    protected String getSpanKind() {
        return SPAN_KIND_NAME;
    }

    private static String getHttpProtocolVersionFrom(HttpProtocol protocol) {
        if (protocol == null) {
            return null;
        }
        if (protocol.equals((Object)HttpProtocol.HTTP_0_9)) {
            return PROTOCOL_VERSION_0_9;
        }
        if (protocol.equals((Object)HttpProtocol.HTTP_1_0)) {
            return PROTOCOL_VERSION_1_0;
        }
        return PROTOCOL_VERSION_1_1;
    }
}

