/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request.profiling.tracing;

import java.net.URI;
import java.net.URISyntaxException;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpCurrentSpanCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCurrentSpanCustomizer.class);
    public static final String HTTP_METHOD = "http.method";
    public static final String HTTP_FLAVOR = "http.flavor";
    public static final String SPAN_KIND = "span.kind.override";

    public void customizeSpan(DistributedTraceContextManager distributedTraceContextManager) {
        try {
            distributedTraceContextManager.setCurrentSpanName(this.getSpanName());
            distributedTraceContextManager.addCurrentSpanAttribute(HTTP_METHOD, this.getMethod());
            distributedTraceContextManager.addCurrentSpanAttribute(SPAN_KIND, this.getSpanKind());
            String flavor = this.getFlavor();
            if (flavor != null) {
                distributedTraceContextManager.addCurrentSpanAttribute(HTTP_FLAVOR, flavor);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Error on customizing Request Span.", e);
        }
    }

    protected String getSpanName() {
        return this.getMethod();
    }

    public abstract String getProtocol();

    public abstract String getMethod();

    public abstract String getFlavor();

    public abstract URI getURI() throws URISyntaxException;

    protected abstract String getSpanKind();
}

