/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request.client;

import java.util.concurrent.CompletableFuture;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.internal.request.ShareableHttpClient;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class HttpExtensionClient
implements Startable,
Stoppable {
    private final HttpRequestAuthentication authentication;
    private final ShareableHttpClient httpClient;
    private final UriParameters uriParameters;

    public HttpExtensionClient(ShareableHttpClient httpClient, UriParameters uriParameters, HttpRequestAuthentication authentication) {
        this.httpClient = httpClient;
        this.uriParameters = uriParameters;
        this.authentication = authentication;
    }

    public UriParameters getDefaultUriParameters() {
        return this.uriParameters;
    }

    public HttpRequestAuthentication getDefaultAuthentication() {
        return this.authentication;
    }

    public void start() throws MuleException {
        this.httpClient.start();
        try {
            LifecycleUtils.startIfNeeded((Object)this.authentication);
        }
        catch (Exception e) {
            this.httpClient.stop();
            throw e;
        }
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.authentication);
        this.httpClient.stop();
    }

    public CompletableFuture<HttpResponse> send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication, HttpSendBodyMode sendBodyMode) {
        return this.httpClient.sendAsync(request, responseTimeout, followRedirects, authentication, sendBodyMode);
    }
}

