/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.UnresolvedAddressException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.error.HttpErrorMessageGenerator;
import org.mule.extension.http.api.error.HttpRequestFailedException;
import org.mule.extension.http.api.notification.HttpNotificationAction;
import org.mule.extension.http.api.notification.HttpRequestNotificationData;
import org.mule.extension.http.api.notification.HttpResponseNotificationData;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.HttpConnectorConstants;
import org.mule.extension.http.internal.request.HttpRequestFactory;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.HttpResponseToResult;
import org.mule.extension.http.internal.request.RequestCreator;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.extension.http.internal.request.profiling.HttpRequestResponseProfilingDataProducerAdaptor;
import org.mule.extension.http.internal.request.profiling.tracing.HttpRequestCurrentSpanCustomizer;
import org.mule.extension.http.internal.request.profiling.tracing.HttpSpanUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequester {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequester.class);
    private static final int WAIT_FOR_EVER = Integer.MAX_VALUE;
    private static int RETRY_ATTEMPTS = Integer.getInteger("mule.http.client.maxRetries", 3);
    private static boolean RETRY_ON_ALL_METHODS = Boolean.getBoolean("mule.http.client.retryOnAllMethods");
    private static final DataType REQUEST_NOTIFICATION_DATA_TYPE = DataType.fromType(HttpRequestNotificationData.class);
    private static final DataType RESPONSE_NOTIFICATION_DATA_TYPE = DataType.fromType(HttpResponseNotificationData.class);
    private final HttpRequestFactory httpRequestFactory;
    private final HttpResponseToResult httpResponseToResult;
    private final HttpErrorMessageGenerator httpErrorMessageGenerator;
    private Optional<HttpRequestResponseProfilingDataProducerAdaptor> profilingDataProducer = Optional.empty();
    private static final Method fireNotificationMethod;

    public HttpRequester(HttpRequestFactory httpRequestFactory, HttpResponseToResult httpResponseToResult, HttpErrorMessageGenerator httpErrorMessageGenerator) {
        this.httpRequestFactory = httpRequestFactory;
        this.httpResponseToResult = httpResponseToResult;
        this.httpErrorMessageGenerator = httpErrorMessageGenerator;
    }

    public HttpRequester(HttpRequestFactory httpRequestFactory, HttpResponseToResult httpResponseToResult, HttpErrorMessageGenerator httpErrorMessageGenerator, HttpRequestResponseProfilingDataProducerAdaptor profilingDataProducer) {
        this(httpRequestFactory, httpResponseToResult, httpErrorMessageGenerator);
        this.profilingDataProducer = Optional.ofNullable(profilingDataProducer);
    }

    private int resolveResponseTimeout(MuleContext muleContext, Integer responseTimeout) {
        if (muleContext.getConfiguration().isDisableTimeouts()) {
            return Integer.MAX_VALUE;
        }
        return responseTimeout != null ? responseTimeout.intValue() : muleContext.getConfiguration().getDefaultResponseTimeout();
    }

    public void doRequest(HttpExtensionClient client, HttpRequesterConfig config, String uri, String method, HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, boolean followRedirects, HttpRequestAuthentication authentication, Integer responseTimeout, ResponseValidator responseValidator, TransformationService transformationService, RequestCreator requestCreator, boolean checkRetry, MuleContext muleContext, Scheduler scheduler, NotificationEmitter notificationEmitter, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback, Map<String, List<String>> injectedHeaders, DistributedTraceContextManager distributedTraceContextManager) {
        int resolvedTimeout = this.resolveResponseTimeout(muleContext, responseTimeout);
        HttpRequest httpRequester = this.httpRequestFactory.create(config, uri, method, streamingMode, sendBodyMode, transformationService, authentication, injectedHeaders, requestCreator, distributedTraceContextManager);
        HttpRequestCurrentSpanCustomizer.getHttpRequesterCurrentSpanCustomizer(httpRequester).customizeSpan(distributedTraceContextManager);
        this.doRequestWithRetry(client, config, uri, method, streamingMode, sendBodyMode, followRedirects, authentication, resolvedTimeout, responseValidator, transformationService, requestCreator, checkRetry, muleContext, scheduler, notificationEmitter, streamingHelper, callback, httpRequester, RETRY_ATTEMPTS, injectedHeaders, distributedTraceContextManager);
    }

    public Result<InputStream, HttpResponseAttributes> doSyncRequest(HttpExtensionClient client, HttpRequesterConfig config, String uri, String method, HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, boolean followRedirects, HttpRequestAuthentication authentication, Integer responseTimeout, ResponseValidator responseValidator, TransformationService transformationService, RequestCreator requestBuilder, boolean checkRetry, MuleContext muleContext, Scheduler scheduler, Map<String, List<String>> injectedHeaders, DistributedTraceContextManager distributedTraceContextManager) throws ExecutionException, InterruptedException {
        final CompletableFuture future = new CompletableFuture();
        CompletionCallback<InputStream, HttpResponseAttributes> callback = new CompletionCallback<InputStream, HttpResponseAttributes>(){

            public void success(Result<InputStream, HttpResponseAttributes> result) {
                future.complete(result);
            }

            public void error(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        };
        this.doRequest(client, config, uri, method, streamingMode, sendBodyMode, followRedirects, authentication, responseTimeout, responseValidator, transformationService, requestBuilder, checkRetry, muleContext, scheduler, null, null, callback, injectedHeaders, distributedTraceContextManager);
        return (Result)future.get();
    }

    private void doRequestWithRetry(HttpExtensionClient client, HttpRequesterConfig config, String uri, String method, HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, boolean followRedirects, HttpRequestAuthentication authentication, int responseTimeout, ResponseValidator responseValidator, TransformationService transformationService, RequestCreator requestCreator, boolean checkRetry, MuleContext muleContext, Scheduler scheduler, NotificationEmitter notificationEmitter, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback, HttpRequest httpRequest, int retryCount, Map<String, List<String>> injectedHeaders, DistributedTraceContextManager distributedTraceContextManager) {
        this.fireNotification(notificationEmitter, HttpNotificationAction.REQUEST_START, () -> HttpRequestNotificationData.from(httpRequest), REQUEST_NOTIFICATION_DATA_TYPE);
        client.send(httpRequest, responseTimeout, followRedirects, this.resolveAuthentication(authentication), sendBodyMode).whenComplete((response, exception) -> {
            if (response != null) {
                try {
                    this.fireNotification(notificationEmitter, HttpNotificationAction.REQUEST_COMPLETE, () -> HttpResponseNotificationData.from(response), RESPONSE_NOTIFICATION_DATA_TYPE);
                    HttpEntity entity = response.getEntity();
                    Supplier<Object> resultInputStreamSupplier = this.resultInputStreamSupplier(streamingHelper, entity, authentication, responseValidator);
                    Result<Object, HttpResponseAttributes> result = this.httpResponseToResult.convert(config, muleContext, (HttpResponse)response, entity, resultInputStreamSupplier, httpRequest.getUri());
                    this.resendRequest(result, checkRetry, authentication, () -> {
                        scheduler.submit(() -> this.consumePayload(result));
                        this.doRequest(client, config, uri, method, streamingMode, sendBodyMode, followRedirects, authentication, responseTimeout, responseValidator, transformationService, requestCreator, false, muleContext, scheduler, notificationEmitter, streamingHelper, callback, injectedHeaders, distributedTraceContextManager);
                    }, () -> {
                        if (distributedTraceContextManager != null) {
                            result.getAttributes().ifPresent(attributes -> {
                                HttpSpanUtils.addStatusCodeAttribute(distributedTraceContextManager, attributes.getStatusCode(), logger);
                                HttpSpanUtils.updateClientSpanStatus(distributedTraceContextManager, attributes.getStatusCode(), logger);
                            });
                        }
                        if (streamingHelper != null) {
                            responseValidator.validate((Result<InputStream, HttpResponseAttributes>)result, httpRequest, streamingHelper);
                        } else {
                            responseValidator.validate((Result<InputStream, HttpResponseAttributes>)result, httpRequest);
                        }
                        Result<Object, HttpResponseAttributes> freshResult = this.httpResponseToResult.convert(config, muleContext, (HttpResponse)response, entity, resultInputStreamSupplier, httpRequest.getUri());
                        String correlationId = requestCreator.getCorrelationData().map(data -> data.getCorrelationInfo().getCorrelationId()).orElse(null);
                        this.profilingDataProducer.ifPresent(profilingDataProducer -> profilingDataProducer.triggerProfilingEvent(result, correlationId));
                        callback.success(freshResult);
                    });
                }
                catch (Exception e) {
                    callback.error((Throwable)e);
                }
            } else {
                this.checkIfRemotelyClosed((Throwable)exception, client.getDefaultUriParameters());
                if (this.shouldRetryRemotelyClosed((Throwable)exception, retryCount, httpRequest)) {
                    this.doRequestWithRetry(client, config, uri, method, streamingMode, sendBodyMode, followRedirects, authentication, responseTimeout, responseValidator, transformationService, requestCreator, checkRetry, muleContext, scheduler, notificationEmitter, streamingHelper, callback, httpRequest, retryCount - 1, injectedHeaders, distributedTraceContextManager);
                    return;
                }
                logger.error(this.getErrorMessage(httpRequest));
                HttpError error = exception instanceof TimeoutException ? HttpError.TIMEOUT : HttpError.CONNECTIVITY;
                callback.error((Throwable)((Object)new HttpRequestFailedException(I18nMessageFactory.createStaticMessage((String)this.httpErrorMessageGenerator.createFrom(httpRequest, this.getExceptionMessage((Throwable)exception))), (Throwable)exception, error)));
            }
        });
    }

    private Supplier<Object> resultInputStreamSupplier(StreamingHelper streamingHelper, HttpEntity entity, HttpRequestAuthentication authentication, ResponseValidator responseValidator) {
        if (streamingHelper == null) {
            return () -> ((HttpEntity)entity).getContent();
        }
        if (!HttpRequester.bodyMayBeConsumed(authentication, responseValidator)) {
            return () -> ((HttpEntity)entity).getContent();
        }
        Object resolved = streamingHelper.resolveCursorProvider((Object)entity.getContent());
        if (resolved instanceof CursorProvider) {
            return () -> ((CursorProvider)((CursorProvider)resolved)).openCursor();
        }
        return () -> (InputStream)resolved;
    }

    private static boolean bodyMayBeConsumed(HttpRequestAuthentication authentication, ResponseValidator responseValidator) {
        boolean authMayConsumeBody = authentication != null && authentication.readsAuthenticatedResponseBody();
        boolean validatorMayConsumeBody = responseValidator != null && responseValidator.mayConsumeBody();
        return authMayConsumeBody || validatorMayConsumeBody;
    }

    private String getExceptionMessage(Throwable t) {
        return this.getExceptionMessage(t, new HashSet<Throwable>());
    }

    private String getExceptionMessage(Throwable t, Set<Throwable> causes) {
        if (causes.add(t)) {
            if (t.getMessage() != null) {
                return t.getMessage();
            }
            if (t instanceof UnresolvedAddressException) {
                return "Couldn't resolve address";
            }
            if (t.getCause() != null) {
                return this.getExceptionMessage(t.getCause(), causes);
            }
        }
        return t.getClass().getSimpleName();
    }

    private void fireNotification(NotificationEmitter notificationEmitter, NotificationActionDefinition action, Supplier<?> data, DataType dataType) {
        if (notificationEmitter == null) {
            return;
        }
        if (fireNotificationMethod == null) {
            notificationEmitter.fire(action, new TypedValue(data.get(), dataType));
            return;
        }
        try {
            fireNotificationMethod.invoke((Object)notificationEmitter, action, data, dataType);
        }
        catch (InvocationTargetException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            notificationEmitter.fire(action, new TypedValue(data.get(), dataType));
        }
    }

    private String getErrorMessage(HttpRequest httpRequest) {
        return String.format("Error sending HTTP request to %s", httpRequest.getUri());
    }

    private void resendRequest(Result result, boolean retry, HttpRequestAuthentication authentication, Runnable retryCallback, Runnable notRetryCallback) {
        if (retry && authentication != null) {
            authentication.retryIfShould((Result<Object, HttpResponseAttributes>)result, retryCallback, notRetryCallback);
        } else {
            notRetryCallback.run();
        }
    }

    private void consumePayload(Result result) {
        if (result.getOutput() instanceof InputStream) {
            try {
                IOUtils.toByteArray((InputStream)((InputStream)result.getOutput()));
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private HttpAuthentication resolveAuthentication(HttpRequestAuthentication authentication) {
        HttpAuthentication requestAuthentication = null;
        if (authentication instanceof HttpAuthentication) {
            requestAuthentication = (HttpAuthentication)authentication;
        }
        return requestAuthentication;
    }

    private void checkIfRemotelyClosed(Throwable exception, UriParameters uriParameters) {
        if (HttpConstants.Protocol.HTTPS.equals((Object)uriParameters.getScheme()) && StringUtils.containsIgnoreCase((CharSequence)exception.getMessage(), (CharSequence)"Remotely closed")) {
            logger.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=ssl for further debugging.");
        }
    }

    private boolean shouldRetryRemotelyClosed(Throwable exception, int retryCount, HttpRequest httpRequest) {
        boolean shouldRetry;
        boolean bl = shouldRetry = exception instanceof IOException && StringUtils.containsIgnoreCase((CharSequence)exception.getMessage(), (CharSequence)"Remotely closed") && this.supportsRetry(httpRequest.getMethod()) && retryCount > 0;
        if (shouldRetry) {
            boolean entitySupportRetry = this.entitySupportRetry(httpRequest);
            if (entitySupportRetry) {
                logger.warn("Sending HTTP message failed with `" + IOException.class.getCanonicalName() + ": " + "Remotely closed" + "`. Request will be retried " + retryCount + " time(s) before failing.");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending HTTP message failed with `" + IOException.class.getCanonicalName() + ": " + "Remotely closed" + "`. Request will not be retried because entity not support retry.");
                }
                shouldRetry = false;
            }
        }
        return shouldRetry;
    }

    private boolean supportsRetry(String httpMethod) {
        return RETRY_ON_ALL_METHODS || HttpConnectorConstants.IDEMPOTENT_METHODS.contains(httpMethod);
    }

    private boolean entitySupportRetry(HttpRequest request) {
        boolean entitySupportRetry = true;
        if (request.getEntity() != null && request.getEntity().isStreaming()) {
            entitySupportRetry = request.getEntity().getContent().markSupported();
        }
        return entitySupportRetry;
    }

    public static void refreshSystemProperties() {
        RETRY_ATTEMPTS = Integer.getInteger("mule.http.client.maxRetries", 3);
        RETRY_ON_ALL_METHODS = Boolean.getBoolean("mule.http.client.retryOnAllMethods");
    }

    static {
        Method fireLazy = null;
        try {
            fireLazy = NotificationEmitter.class.getDeclaredMethod("fireLazy", NotificationActionDefinition.class, Supplier.class, DataType.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        fireNotificationMethod = fireLazy;
    }
}

