/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.request.CorrelationData;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.RequestCreator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestFactory.class);
    private static final String CONTENT_TYPE_HEADER = "Content-Type".toLowerCase();
    private static final String CONTENT_LENGTH_HEADER = "Content-Length".toLowerCase();
    private static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding".toLowerCase();
    private static final String X_CORRELATION_ID_HEADER = "X-Correlation-ID".toLowerCase();
    private static final String MULE_CORRELATION_ID_PROPERTY_HEADER = "MULE_CORRELATION_ID".toLowerCase();
    private static final String COOKIE_HEADER = "Cookie".toLowerCase();
    private static final Set<String> DEFAULT_EMPTY_BODY_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS")));
    private static final String BOTH_TRANSFER_HEADERS_SET_MESSAGE = "Cannot send both Transfer-Encoding and Content-Length headers. Transfer-Encoding will not be sent.";
    private static final String TRANSFER_ENCODING_NOT_ALLOWED_WHEN_NEVER_MESSAGE = "Transfer-Encoding header will not be sent, as the configured requestStreamingMode is NEVER.";
    private static final String INVALID_TRANSFER_ENCODING_HEADER_MESSAGE = "Transfer-Encoding header value was invalid and will not be sent.";
    private static final String COOKIES_SEPARATOR = "; ";
    private boolean logFirstIgnoredBody = true;

    public HttpRequest create(HttpRequesterConfig config, String uri, String method, HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, TransformationService transformationService, HttpRequestAuthentication authentication, Map<String, List<String>> injectedHeaders, RequestCreator httpRequestCreator, DistributedTraceContextManager distributedTraceContextManager) {
        HttpRequestBuilder builder = httpRequestCreator.createRequestBuilder(config).uri(uri).method(method);
        config.getDefaultHeaders().forEach(header -> {
            HttpRequestBuilder cfr_ignored_0 = (HttpRequestBuilder)builder.addHeader(header.getKey(), header.getValue());
        });
        injectedHeaders.forEach((headerName, headerValues) -> {
            for (String headerValue : headerValues) {
                builder.addHeader(headerName, headerValue);
            }
        });
        config.getDefaultQueryParams().forEach(param -> builder.addQueryParam(param.getKey(), param.getValue()));
        httpRequestCreator.getCorrelationData().ifPresent(correlationData -> this.addCorrelationIdResolution((CorrelationData)correlationData, builder));
        if (config.isEnableCookies()) {
            this.addCookiesHeader(config, uri, builder);
        }
        distributedTraceContextManager.getRemoteTraceContextMap().forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).addHeader(arg_0, arg_1));
        try {
            builder.entity(this.createRequestEntity(streamingMode, sendBodyMode, transformationService, builder, method, httpRequestCreator.getBody()));
        }
        catch (Exception e) {
            throw new ModuleException((ErrorTypeDefinition)HttpError.TRANSFORMATION, (Throwable)e);
        }
        if (authentication != null) {
            try {
                authentication.authenticate(builder);
            }
            catch (MuleException e) {
                throw new ModuleException((ErrorTypeDefinition)HttpError.SECURITY, (Throwable)e);
            }
        }
        return builder.build();
    }

    private void addCorrelationIdResolution(CorrelationData correlationData, HttpRequestBuilder builder) {
        correlationData.getSendCorrelationId().getOutboundCorrelationId(correlationData.getCorrelationInfo(), correlationData.getCorrelationId()).ifPresent(correlationId -> {
            String xCorrelationId;
            if (builder.getHeaderValue(X_CORRELATION_ID_HEADER).isPresent()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("X-Correlation-ID was specified both as explicit header and through the standard propagation of the mule correlation ID. The explicit header will prevail.");
                }
                xCorrelationId = (String)builder.getHeaderValue(X_CORRELATION_ID_HEADER).get();
            } else {
                xCorrelationId = correlationId;
                builder.addHeader(X_CORRELATION_ID_HEADER, correlationId);
            }
            builder.getHeaderValue(MULE_CORRELATION_ID_PROPERTY_HEADER).ifPresent(muleCorrelationId -> LOGGER.warn("Explicitly configured 'MULE_CORRELATION_ID: {}' header could interfere with 'X-Correlation-ID: {}' header.", muleCorrelationId, (Object)xCorrelationId));
        });
    }

    private void addCookiesHeader(HttpRequesterConfig config, String uri, HttpRequestBuilder builder) {
        try {
            List<String> cookies = config.getCookieManager().get(builder.getUri(), Collections.emptyMap()).get("Cookie");
            if (cookies != null && cookies.size() > 0) {
                int totalHeaderLength = COOKIES_SEPARATOR.length() * (cookies.size() - 1);
                for (String cookie : cookies) {
                    totalHeaderLength += cookie.length();
                }
                StringBuilder sb = new StringBuilder(totalHeaderLength).append(cookies.get(0));
                for (int index = 1; index < cookies.size(); ++index) {
                    sb.append(COOKIES_SEPARATOR).append(cookies.get(index));
                }
                builder.addHeader(COOKIE_HEADER, sb.toString());
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error reading cookies for URI " + uri, (Throwable)e);
        }
    }

    private HttpEntity createRequestEntity(HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, TransformationService transformationService, HttpRequestBuilder requestBuilder, String resolvedMethod, TypedValue<?> body) {
        Object entity;
        Object payload = body.getValue();
        OptionalLong length = body.getByteLength();
        Optional transferEncoding = requestBuilder.getHeaderValue(TRANSFER_ENCODING_HEADER);
        Optional contentLength = requestBuilder.getHeaderValue(CONTENT_LENGTH_HEADER);
        boolean emptyBody = this.isEmptyBody(payload, resolvedMethod, sendBodyMode);
        MediaType mediaType = body.getDataType().getMediaType();
        if (!(requestBuilder.getHeaderValue(CONTENT_TYPE_HEADER).isPresent() || emptyBody || MediaType.ANY.matches(mediaType))) {
            requestBuilder.addHeader(CONTENT_TYPE_HEADER, mediaType.toRfcString());
        }
        if (emptyBody) {
            entity = new EmptyHttpEntity();
        } else if (payload instanceof CursorStreamProvider) {
            if (streamingMode == HttpStreamingType.ALWAYS) {
                entity = this.guaranteeStreaming(requestBuilder, (Optional<String>)transferEncoding, (Optional<String>)contentLength, (CursorStreamProvider)payload);
            } else if (streamingMode == HttpStreamingType.AUTO) {
                if (contentLength.isPresent()) {
                    this.sanitizeForContentLength(requestBuilder, transferEncoding, BOTH_TRANSFER_HEADERS_SET_MESSAGE);
                    entity = new ByteArrayHttpEntity(this.getPayloadAsBytes(((CursorStreamProvider)payload).openCursor(), transformationService));
                } else if (transferEncoding.isPresent() && "chunked".equalsIgnoreCase((String)transferEncoding.get()) || !length.isPresent()) {
                    entity = new RepeatableInputStreamHttpEntity((CursorStreamProvider)payload);
                } else {
                    this.sanitizeForContentLength(requestBuilder, transferEncoding, INVALID_TRANSFER_ENCODING_HEADER_MESSAGE);
                    entity = this.avoidConsumingPayload(requestBuilder, (CursorStreamProvider)payload, length);
                }
            } else {
                this.sanitizeForContentLength(requestBuilder, transferEncoding, TRANSFER_ENCODING_NOT_ALLOWED_WHEN_NEVER_MESSAGE);
                entity = length.isPresent() ? this.avoidConsumingPayload(requestBuilder, (CursorStreamProvider)payload, length) : new ByteArrayHttpEntity(this.getPayloadAsBytes(((CursorStreamProvider)payload).openCursor(), transformationService));
            }
        } else if (payload instanceof InputStream) {
            if (streamingMode == HttpStreamingType.ALWAYS) {
                entity = this.guaranteeStreaming(requestBuilder, (Optional<String>)transferEncoding, (Optional<String>)contentLength, (InputStream)payload);
            } else if (streamingMode == HttpStreamingType.AUTO) {
                if (contentLength.isPresent()) {
                    this.sanitizeForContentLength(requestBuilder, transferEncoding, BOTH_TRANSFER_HEADERS_SET_MESSAGE);
                    entity = new ByteArrayHttpEntity(this.getPayloadAsBytes(payload, transformationService));
                } else if (transferEncoding.isPresent() && "chunked".equalsIgnoreCase((String)transferEncoding.get()) || !length.isPresent()) {
                    entity = new InputStreamHttpEntity((InputStream)payload);
                } else {
                    this.sanitizeForContentLength(requestBuilder, transferEncoding, INVALID_TRANSFER_ENCODING_HEADER_MESSAGE);
                    entity = this.avoidConsumingPayload(requestBuilder, (InputStream)payload, length);
                }
            } else {
                this.sanitizeForContentLength(requestBuilder, transferEncoding, TRANSFER_ENCODING_NOT_ALLOWED_WHEN_NEVER_MESSAGE);
                entity = length.isPresent() ? this.avoidConsumingPayload(requestBuilder, (InputStream)payload, length) : new ByteArrayHttpEntity(this.getPayloadAsBytes(payload, transformationService));
            }
        } else {
            byte[] payloadAsBytes = this.getPayloadAsBytes(payload, transformationService);
            if (streamingMode == HttpStreamingType.ALWAYS) {
                entity = this.guaranteeStreaming(requestBuilder, (Optional<String>)transferEncoding, (Optional<String>)contentLength, new ByteArrayInputStream(payloadAsBytes));
            } else if (streamingMode == HttpStreamingType.NEVER) {
                this.sanitizeForContentLength(requestBuilder, transferEncoding, TRANSFER_ENCODING_NOT_ALLOWED_WHEN_NEVER_MESSAGE);
                entity = new ByteArrayHttpEntity(payloadAsBytes);
            } else {
                if (contentLength.isPresent() && transferEncoding.isPresent()) {
                    this.sanitizeForContentLength(requestBuilder, transferEncoding, BOTH_TRANSFER_HEADERS_SET_MESSAGE);
                }
                entity = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(payloadAsBytes), Long.valueOf(payloadAsBytes.length));
            }
        }
        return entity;
    }

    private boolean isEmptyBody(Object body, String method, HttpSendBodyMode sendBodyMode) {
        boolean emptyBody;
        boolean hasBody;
        boolean bl = hasBody = body != null && !body.equals("");
        if (!hasBody) {
            emptyBody = true;
        } else {
            emptyBody = DEFAULT_EMPTY_BODY_METHODS.contains(method);
            if (sendBodyMode != HttpSendBodyMode.AUTO) {
                boolean bl2 = emptyBody = sendBodyMode == HttpSendBodyMode.NEVER;
            }
        }
        if (emptyBody && hasBody && this.logFirstIgnoredBody) {
            this.logFirstIgnoredBody = false;
            LOGGER.warn("Body is ignored since the HTTP Method is between the empty body methods ({}) and the Send Body Mode is not set to 'ALWAYS'. future warnings like this will be suppressed in order to avoid performance degradations", DEFAULT_EMPTY_BODY_METHODS);
        }
        return emptyBody;
    }

    private HttpEntity guaranteeStreaming(HttpRequestBuilder requestBuilder, Optional<String> transferEncoding, Optional<String> contentLength, InputStream stream) {
        this.sanitizeForStreaming(requestBuilder, transferEncoding, contentLength);
        return new InputStreamHttpEntity(stream);
    }

    private HttpEntity guaranteeStreaming(HttpRequestBuilder requestBuilder, Optional<String> transferEncoding, Optional<String> contentLength, CursorStreamProvider streamProvider) {
        this.sanitizeForStreaming(requestBuilder, transferEncoding, contentLength);
        return new RepeatableInputStreamHttpEntity(streamProvider);
    }

    private HttpEntity avoidConsumingPayload(HttpRequestBuilder requestBuilder, InputStream payload, OptionalLong length) {
        requestBuilder.addHeader("Content-Length", String.valueOf(length.getAsLong()));
        return new InputStreamHttpEntity(payload, Long.valueOf(length.getAsLong()));
    }

    private HttpEntity avoidConsumingPayload(HttpRequestBuilder requestBuilder, CursorStreamProvider streamProvider, OptionalLong length) {
        requestBuilder.addHeader("Content-Length", String.valueOf(length.getAsLong()));
        return new RepeatableInputStreamHttpEntity(streamProvider, length.getAsLong());
    }

    private byte[] getPayloadAsBytes(Object payload, TransformationService transformationService) {
        return (byte[])transformationService.transform(Message.of((Object)payload), DataType.BYTE_ARRAY).getPayload().getValue();
    }

    private void sanitizeForStreaming(HttpRequestBuilder requestBuilder, Optional<String> transferEncodingHeader, Optional<String> contentLengthHeader) {
        if (contentLengthHeader != null) {
            requestBuilder.removeHeader("Content-Length");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Content-Length header will not be sent, as the configured requestStreamingMode is ALWAYS.");
            }
        }
        if (transferEncodingHeader.isPresent() && !transferEncodingHeader.get().equalsIgnoreCase("chunked")) {
            requestBuilder.removeHeader("Transfer-Encoding");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer-Encoding header will be sent with value 'chunked' instead of {}, as the configured requestStreamingMode is ALWAYS", transferEncodingHeader);
            }
        }
    }

    private void sanitizeForContentLength(HttpRequestBuilder requestBuilder, Optional<String> transferEncoding, String reason) {
        if (transferEncoding.isPresent()) {
            requestBuilder.removeHeader("Transfer-Encoding");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(reason);
            }
        }
    }

    private class RepeatableInputStreamHttpEntity
    implements HttpEntity {
        private Long contentLength;
        private final CursorStreamProvider streamProvider;

        public RepeatableInputStreamHttpEntity(CursorStreamProvider streamProvider) {
            Preconditions.checkNotNull((Object)streamProvider, (String)"HTTP entity stream provider cannot be null.");
            this.streamProvider = streamProvider;
        }

        public RepeatableInputStreamHttpEntity(CursorStreamProvider streamProvider, Long contentLength) {
            this(streamProvider);
            this.contentLength = contentLength;
        }

        public boolean isStreaming() {
            return true;
        }

        public boolean isComposed() {
            return false;
        }

        public InputStream getContent() {
            return (InputStream)this.streamProvider.openCursor();
        }

        public byte[] getBytes() {
            return IOUtils.toByteArray((InputStream)this.getContent());
        }

        public Collection<HttpPart> getParts() {
            return Collections.emptyList();
        }

        public Optional<Long> getLength() {
            return Optional.ofNullable(this.contentLength);
        }
    }
}

