/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public final class HttpClientReflection {
    public static final String HTTP_CLIENT_CLASS_NAME = "org.mule.runtime.http.api.client.HttpClient";
    public static final String HTTP_REQUEST_OPTIONS_CLASS_NAME = "org.mule.runtime.http.api.client.HttpRequestOptions";
    public static final String HTTP_REQUEST_OPTIONS_BUILDER_CLASS_NAME = "org.mule.runtime.http.api.client.HttpRequestOptionsBuilder";
    private static Method builderMethod;
    private static Method sendAsyncMethod;
    private static Method buildMethod;
    private static Method responseTimeoutMethod;
    private static Method followsRedirectMethod;
    private static Method authenticationMethod;
    private static Method sendBodyAlwaysMethod;
    static boolean loaded;

    private HttpClientReflection() {
    }

    private static Object requestOptions(int responseTimeout, boolean followsRedirect, HttpAuthentication authentication, HttpSendBodyMode sendBodyMode) throws InvocationTargetException, IllegalAccessException {
        Object requestOptionsBuilder = builderMethod.invoke(null, new Object[0]);
        requestOptionsBuilder = responseTimeoutMethod.invoke(requestOptionsBuilder, responseTimeout);
        requestOptionsBuilder = followsRedirectMethod.invoke(requestOptionsBuilder, followsRedirect);
        requestOptionsBuilder = authenticationMethod.invoke(requestOptionsBuilder, authentication);
        requestOptionsBuilder = sendBodyAlwaysMethod.invoke(requestOptionsBuilder, sendBodyMode.equals((Object)HttpSendBodyMode.ALWAYS));
        return buildMethod.invoke(requestOptionsBuilder, new Object[0]);
    }

    public static CompletableFuture<HttpResponse> sendAsync(HttpClient client, HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication, HttpSendBodyMode sendBodyMode) {
        if (loaded) {
            try {
                return HttpClientReflection.invokeSendAsyncUnsafe(client, request, responseTimeout, followRedirects, authentication, sendBodyMode);
            }
            catch (InvocationTargetException e) {
                throw HttpClientReflection.wrapRuntimeException(e.getTargetException());
            }
            catch (IllegalAccessException e) {
                return client.sendAsync(request, responseTimeout, followRedirects, authentication);
            }
        }
        return client.sendAsync(request, responseTimeout, followRedirects, authentication);
    }

    private static CompletableFuture<HttpResponse> invokeSendAsyncUnsafe(HttpClient client, HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication, HttpSendBodyMode sendBodyMode) throws IllegalAccessException, InvocationTargetException {
        return (CompletableFuture)sendAsyncMethod.invoke((Object)client, request, HttpClientReflection.requestOptions(responseTimeout, followRedirects, authentication, sendBodyMode));
    }

    private static RuntimeException wrapRuntimeException(Throwable exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(exception);
    }

    static {
        loaded = true;
        try {
            Class<?> httpRequestOptionsClass = Class.forName(HTTP_REQUEST_OPTIONS_CLASS_NAME);
            builderMethod = httpRequestOptionsClass.getDeclaredMethod("builder", new Class[0]);
            Class<?> builderClass = Class.forName(HTTP_REQUEST_OPTIONS_BUILDER_CLASS_NAME);
            buildMethod = builderClass.getDeclaredMethod("build", new Class[0]);
            responseTimeoutMethod = builderClass.getDeclaredMethod("responseTimeout", Integer.TYPE);
            followsRedirectMethod = builderClass.getDeclaredMethod("followsRedirect", Boolean.TYPE);
            authenticationMethod = builderClass.getDeclaredMethod("authentication", HttpAuthentication.class);
            sendBodyAlwaysMethod = builderClass.getDeclaredMethod("sendBodyAlways", Boolean.TYPE);
            Class<?> httpClientClass = Class.forName(HTTP_CLIENT_CLASS_NAME);
            sendAsyncMethod = httpClientClass.getDeclaredMethod("sendAsync", HttpRequest.class, httpRequestOptionsClass);
        }
        catch (Exception ignored) {
            loaded = false;
        }
    }
}

