/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerPath {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListenerPath.class);
    private final String basePath;
    private final String resolvedPath;

    public ListenerPath(String basePath, String listenerPath) {
        this.basePath = basePath;
        this.resolvedPath = basePath == null ? listenerPath : this.pathWithoutEndSlash(basePath) + listenerPath;
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    public String getRelativePath(String requestPath) {
        Preconditions.checkArgument((boolean)requestPath.startsWith("/"), (String)"requestPath must start with '/'");
        if (this.isEmptyBasePath()) {
            return requestPath;
        }
        String basePathWithoutEndSlash = this.pathWithoutEndSlash(this.basePath);
        if (!requestPath.startsWith(basePathWithoutEndSlash)) {
            LOGGER.warn("Request path '{}' doesn't start with base path '{}'", (Object)requestPath, (Object)this.basePath);
            return requestPath;
        }
        return requestPath.substring(basePathWithoutEndSlash.length());
    }

    private String pathWithoutEndSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private boolean isEmptyBasePath() {
        return this.basePath == null || this.basePath.isEmpty() || this.basePath.equals("/");
    }
}

