/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.listener.HttpResponseContext;
import org.mule.extension.http.internal.listener.HttpResponseFactory;
import org.mule.extension.http.internal.listener.intercepting.Interception;
import org.mule.extension.http.internal.request.profiling.tracing.HttpSpanUtils;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListenerResponseSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpListenerResponseSender.class);
    private final HttpResponseFactory responseFactory;

    public HttpListenerResponseSender(HttpResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
    }

    public HttpListenerResponseSender(TransformationService transformationService) {
        this.responseFactory = new HttpResponseFactory(HttpStreamingType.NEVER, transformationService, () -> false);
    }

    public void sendResponse(HttpResponseContext context, HttpListenerResponseBuilder response, SourceCompletionCallback completionCallback, DistributedTraceContextManager distributedTraceContextManager) {
        HttpResponse httpResponse = this.buildResponse(response, context.getInterception(), context.isSupportStreaming());
        HttpResponseReadyCallback responseCallback = context.getResponseCallback();
        HttpSpanUtils.addStatusCodeAttribute(distributedTraceContextManager, httpResponse.getStatusCode(), LOGGER);
        HttpSpanUtils.updateServerSpanStatus(distributedTraceContextManager, httpResponse.getStatusCode(), LOGGER);
        responseCallback.responseReady(httpResponse, this.getResponseFailureCallback(responseCallback, completionCallback));
    }

    protected HttpResponse buildResponse(HttpListenerResponseBuilder listenerResponseBuilder, Interception interception, boolean supportStreaming) {
        return this.responseFactory.create(HttpResponse.builder(), interception, listenerResponseBuilder, supportStreaming);
    }

    public ResponseStatusCallback getResponseFailureCallback(HttpResponseReadyCallback responseReadyCallback, SourceCompletionCallback completionCallback) {
        return new FailureResponseStatusCallback(responseReadyCallback, completionCallback);
    }

    public static class FailureResponseStatusCallback
    implements ResponseStatusCallback {
        private HttpResponseReadyCallback responseReadyCallback;
        private SourceCompletionCallback completionCallback;

        public FailureResponseStatusCallback(HttpResponseReadyCallback responseReadyCallback, SourceCompletionCallback completionCallback) {
            this.responseReadyCallback = responseReadyCallback;
            this.completionCallback = completionCallback;
        }

        public void responseSendFailure(Throwable throwable) {
            try {
                this.responseReadyCallback.responseReady(this.buildErrorResponse(), (ResponseStatusCallback)this);
                this.completionCallback.success();
            }
            catch (Throwable t) {
                this.completionCallback.error(t);
            }
        }

        public void responseSendSuccessfully() {
            this.completionCallback.success();
        }

        public void onErrorSendingResponse(Throwable throwable) {
            this.completionCallback.error(throwable);
        }

        protected HttpResponse buildErrorResponse() {
            HttpResponseBuilder errorResponseBuilder = HttpResponse.builder();
            HttpResponse errorResponse = errorResponseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()).build();
            return errorResponse;
        }
    }
}

