/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.db.commons.shaded.api.param.BulkQueryDefinition;
import org.mule.db.commons.shaded.api.param.OutputParameter;
import org.mule.db.commons.shaded.api.param.ParameterType;
import org.mule.db.commons.shaded.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.shaded.api.param.QueryDefinition;
import org.mule.db.commons.shaded.api.param.QuerySettings;
import org.mule.db.commons.shaded.api.param.TransactionIsolation;
import org.mule.db.commons.shaded.api.param.TypeClassifier;
import org.mule.extension.db.api.param.BulkScript;
import org.mule.extension.db.api.param.JdbcType;
import org.mule.extension.db.api.param.StoredProcedureCall;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.runtime.api.tls.TlsContextFactory;

public class MigrationUtils {
    public static org.mule.db.commons.shaded.api.param.BulkScript mapBulkScript(BulkScript bulkScript) {
        if (Objects.isNull(bulkScript)) {
            return null;
        }
        return new org.mule.db.commons.shaded.api.param.BulkScript(bulkScript.getSql(), bulkScript.getFile());
    }

    public static QuerySettings mapQuerySettings(org.mule.extension.db.api.param.QuerySettings querySettings) {
        if (Objects.isNull(querySettings)) {
            return null;
        }
        return new QuerySettings(querySettings.getQueryTimeout(), querySettings.getQueryTimeoutUnit(), querySettings.getFetchSize(), querySettings.getMaxRows());
    }

    public static BulkQueryDefinition mapBulkQueryDefinition(org.mule.extension.db.api.param.BulkQueryDefinition queryDefinition) {
        if (Objects.isNull(queryDefinition)) {
            return null;
        }
        List<ParameterType> paramTypes = queryDefinition.getParameterTypes().stream().map(x -> MigrationUtils.mapParameterType(x)).collect(Collectors.toList());
        return new BulkQueryDefinition(queryDefinition.getSql(), paramTypes, queryDefinition.getQueryTimeout(), queryDefinition.getQueryTimeoutUnit(), queryDefinition.getFetchSize(), queryDefinition.getMaxRows());
    }

    public static ParameterType mapParameterType(org.mule.extension.db.api.param.ParameterType parameterType) {
        if (Objects.isNull(parameterType)) {
            return null;
        }
        return new ParameterType(parameterType.getKey(), MigrationUtils.mapTypeClassifier(parameterType.getTypeClassifier()));
    }

    public static TypeClassifier mapTypeClassifier(org.mule.extension.db.api.param.TypeClassifier typeClassifier) {
        if (Objects.isNull(typeClassifier)) {
            return null;
        }
        return new TypeClassifier(MigrationUtils.mapJdbcType(typeClassifier.getJdbcType()), typeClassifier.getCustomType());
    }

    public static org.mule.db.commons.shaded.api.param.JdbcType mapJdbcType(JdbcType jdbcType) {
        if (Objects.isNull((Object)jdbcType)) {
            return null;
        }
        switch (jdbcType) {
            case BIT: {
                return org.mule.db.commons.shaded.api.param.JdbcType.BIT;
            }
            case REF: {
                return org.mule.db.commons.shaded.api.param.JdbcType.REF;
            }
            case BLOB: {
                return org.mule.db.commons.shaded.api.param.JdbcType.BLOB;
            }
            case CHAR: {
                return org.mule.db.commons.shaded.api.param.JdbcType.CHAR;
            }
            case CLOB: {
                return org.mule.db.commons.shaded.api.param.JdbcType.CLOB;
            }
            case DATE: {
                return org.mule.db.commons.shaded.api.param.JdbcType.DATE;
            }
            case NULL: {
                return org.mule.db.commons.shaded.api.param.JdbcType.NULL;
            }
            case REAL: {
                return org.mule.db.commons.shaded.api.param.JdbcType.REAL;
            }
            case TIME: {
                return org.mule.db.commons.shaded.api.param.JdbcType.TIME;
            }
            case ARRAY: {
                return org.mule.db.commons.shaded.api.param.JdbcType.ARRAY;
            }
            case FLOAT: {
                return org.mule.db.commons.shaded.api.param.JdbcType.FLOAT;
            }
            case NCHAR: {
                return org.mule.db.commons.shaded.api.param.JdbcType.NCHAR;
            }
            case NCLOB: {
                return org.mule.db.commons.shaded.api.param.JdbcType.NCLOB;
            }
            case OTHER: {
                return org.mule.db.commons.shaded.api.param.JdbcType.OTHER;
            }
            case ROWID: {
                return org.mule.db.commons.shaded.api.param.JdbcType.ROWID;
            }
            case BIGINT: {
                return org.mule.db.commons.shaded.api.param.JdbcType.BIGINT;
            }
            case BINARY: {
                return org.mule.db.commons.shaded.api.param.JdbcType.BINARY;
            }
            case DOUBLE: {
                return org.mule.db.commons.shaded.api.param.JdbcType.DOUBLE;
            }
            case SQLXML: {
                return org.mule.db.commons.shaded.api.param.JdbcType.SQLXML;
            }
            case STRUCT: {
                return org.mule.db.commons.shaded.api.param.JdbcType.STRUCT;
            }
            case BOOLEAN: {
                return org.mule.db.commons.shaded.api.param.JdbcType.BOOLEAN;
            }
            case DECIMAL: {
                return org.mule.db.commons.shaded.api.param.JdbcType.DECIMAL;
            }
            case INTEGER: {
                return org.mule.db.commons.shaded.api.param.JdbcType.INTEGER;
            }
            case NUMERIC: {
                return org.mule.db.commons.shaded.api.param.JdbcType.NUMERIC;
            }
            case TINYINT: {
                return org.mule.db.commons.shaded.api.param.JdbcType.TINYINT;
            }
            case UNKNOWN: {
                return org.mule.db.commons.shaded.api.param.JdbcType.UNKNOWN;
            }
            case VARCHAR: {
                return org.mule.db.commons.shaded.api.param.JdbcType.VARCHAR;
            }
            case DATALINK: {
                return org.mule.db.commons.shaded.api.param.JdbcType.DATALINK;
            }
            case DISTINCT: {
                return org.mule.db.commons.shaded.api.param.JdbcType.DISTINCT;
            }
            case NVARCHAR: {
                return org.mule.db.commons.shaded.api.param.JdbcType.NVARCHAR;
            }
            case SMALLINT: {
                return org.mule.db.commons.shaded.api.param.JdbcType.SMALLINT;
            }
            case TIMESTAMP: {
                return org.mule.db.commons.shaded.api.param.JdbcType.TIMESTAMP;
            }
            case VARBINARY: {
                return org.mule.db.commons.shaded.api.param.JdbcType.VARBINARY;
            }
            case JAVA_OBJECT: {
                return org.mule.db.commons.shaded.api.param.JdbcType.JAVA_OBJECT;
            }
            case LONGVARCHAR: {
                return org.mule.db.commons.shaded.api.param.JdbcType.LONGVARCHAR;
            }
            case LONGNVARCHAR: {
                return org.mule.db.commons.shaded.api.param.JdbcType.LONGNVARCHAR;
            }
            case LONGVARBINARY: {
                return org.mule.db.commons.shaded.api.param.JdbcType.LONGVARBINARY;
            }
            case REF_CURSOR: {
                return org.mule.db.commons.shaded.api.param.JdbcType.REF_CURSOR;
            }
        }
        throw new RuntimeException("Invalid JDBC Type Translation");
    }

    public static org.mule.db.commons.shaded.api.param.StoredProcedureCall mapStoredProcedureCall(StoredProcedureCall spCall) {
        if (Objects.isNull(spCall)) {
            return null;
        }
        List<ParameterType> parameterTypes = spCall.getParameterTypes().stream().map(x -> MigrationUtils.mapParameterType(x)).collect(Collectors.toList());
        List<OutputParameter> outputParameterTypes = spCall.getOutputParameters().stream().map(x -> new OutputParameter(x.getKey(), MigrationUtils.mapTypeClassifier(x.getTypeClassifier()))).collect(Collectors.toList());
        return new org.mule.db.commons.shaded.api.param.StoredProcedureCall(spCall.getSql(), parameterTypes, spCall.getInputParameters(), spCall.getInOutParameters(), outputParameterTypes, spCall.getQueryTimeout(), spCall.getQueryTimeoutUnit(), spCall.getFetchSize(), spCall.getMaxRows());
    }

    public static QueryDefinition mapQueryDefinition(org.mule.extension.db.api.param.QueryDefinition queryDefinition) {
        if (Objects.isNull(queryDefinition)) {
            return null;
        }
        List<ParameterType> parameterTypes = queryDefinition.getParameterTypes().stream().map(x -> MigrationUtils.mapParameterType(x)).collect(Collectors.toList());
        return new QueryDefinition(queryDefinition.getSql(), parameterTypes, queryDefinition.getInputParameters(), queryDefinition.getQueryTimeout(), queryDefinition.getQueryTimeoutUnit(), queryDefinition.getFetchSize(), queryDefinition.getMaxRows());
    }

    public static org.mule.db.commons.shaded.internal.domain.connection.DataSourceConfig mapDataSourceConfig(final DataSourceConfig dsConfig) {
        if (Objects.isNull(dsConfig)) {
            return null;
        }
        return new org.mule.db.commons.shaded.internal.domain.connection.DataSourceConfig(){

            @Override
            public String getUrl() {
                return dsConfig.getUrl();
            }

            @Override
            public String getDriverClassName() {
                return dsConfig.getDriverClassName();
            }

            @Override
            public String getPassword() {
                return dsConfig.getPassword();
            }

            @Override
            public String getUser() {
                return dsConfig.getUser();
            }

            @Override
            public TransactionIsolation getTransactionIsolation() {
                switch (dsConfig.getTransactionIsolation()) {
                    case NONE: {
                        return TransactionIsolation.NONE;
                    }
                    case SERIALIZABLE: {
                        return TransactionIsolation.SERIALIZABLE;
                    }
                    case NOT_CONFIGURED: {
                        return TransactionIsolation.NOT_CONFIGURED;
                    }
                    case READ_COMMITTED: {
                        return TransactionIsolation.READ_COMMITTED;
                    }
                    case READ_UNCOMMITTED: {
                        return TransactionIsolation.READ_UNCOMMITTED;
                    }
                    case REPEATABLE_READ: {
                        return TransactionIsolation.REPEATABLE_READ;
                    }
                }
                throw new RuntimeException("Invalid Transaction Isolation Value for translation");
            }

            @Override
            public boolean isUseXaTransactions() {
                return dsConfig.isUseXaTransactions();
            }

            @Override
            public Optional<TlsContextFactory> getTlsContextFactory() {
                return dsConfig.getTlsContextFactory();
            }
        };
    }

    public static ParameterizedStatementDefinition mapParameterizedStatementDefinition(org.mule.extension.db.api.param.ParameterizedStatementDefinition def) {
        if (Objects.isNull(def)) {
            return null;
        }
        return new ParameterizedStatementDefinition(def.getSql(), def.getParameterTypes(), (Map)def.getInputParameters(), def.getQueryTimeout(), def.getQueryTimeoutUnit(), def.getFetchSize(), def.getMaxRows()){};
    }
}

