/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.source;

import java.sql.SQLException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;

public class TableKeyResolver
implements TypeKeysResolver {
    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        Set<MetadataKey> metadataKeys;
        Optional connection = context.getConnection();
        DbConnection dbConnection = (DbConnection)connection.orElseThrow(() -> new MetadataResolvingException("No connection available to retrieve existing tables", FailureCode.CONNECTION_FAILURE));
        try {
            metadataKeys = dbConnection.getTables().stream().map(tableName -> MetadataKeyBuilder.newKey((String)tableName).build()).collect(Collectors.toSet());
        }
        catch (SQLException e) {
            throw new MetadataResolvingException("Unexpected error when retrieving existing tables", FailureCode.UNKNOWN, (Throwable)e);
        }
        return metadataKeys;
    }

    public String getCategoryName() {
        return "DbCategory";
    }
}

