/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.source;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public class ColumnValueProvider
implements ValueProvider {
    @Parameter
    private String table;
    @Connection
    private DbConnection dbConnection;

    public Set<Value> resolve() throws ValueResolvingException {
        HashSet<Value> values = new HashSet<Value>();
        try {
            ResultSet tables = this.dbConnection.getJdbcConnection().getMetaData().getColumns(null, null, this.table, null);
            while (tables.next()) {
                values.add(ValueBuilder.newValue((String)tables.getString("COLUMN_NAME")).build());
            }
        }
        catch (SQLException e) {
            throw new ValueResolvingException(String.format("Unexpected error occurred trying to obtain Column Names for table [%s]", this.table), "UNKNOWN", (Throwable)e);
        }
        return values;
    }
}

